Name: CVector
Version: 1.0.3.1
Release: alt2

Summary: ANSI C API for Dynamic Arrays
License: LGPLv2+
Group: System/Libraries

Url: http://cvector.sourceforge.net
Source: http://downloads.sourceforge.net/project/cvector/cvector/CVector-%version/CVector-%version.tar.gz
# to fix /-dynamic/-rdynamic/ issue, reported to upstream
Patch0: CVector-1.0.3.1-dynamic.patch
# to fix libdir for lib64 architecture
Patch1: CVector-1.0.3-lib64.patch
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: gcc-c++

%description
CVector is an ANSI C implementation of dynamic arrays to provide
a crude approximation to the C++ vector class.

%package -n lib%name
Summary: Shared library for CVector
Group: System/Libraries

%description -n lib%name
This package includes the shared library files
for running applications that use CVector.

%package -n lib%name-devel
Summary: Development tools for compiling programs using CVector
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package includes the header and library files
for developing applications that use CVector.

%prep
%setup
%patch0 -p1 -b .dynamic
%if %_lib == lib64
%patch1 -p1 -b .lib64
%endif
sed -i -r 's,(--mode=(compile|link)),--tag=CC \1,' Makefile

%build
%make_build

%install
%make_install install INSTALL_PREFIX="%buildroot%prefix"
find %buildroot -name '*.la' -exec rm -f {} ';'
find %buildroot -name '*.a' -exec rm -f {} ';'

%check
make tests

%files -n lib%name
%doc README_CVector.html README_CVector.txt lgpl.txt
%_libdir/libCVector-*.so.*

%files -n lib%name-devel
%_includedir/CVector.h
%_libdir/libCVector.so

%changelog
