Name: GLC_Player
Version: 2.3.0
Release: alt3.20200519
Summary: GLC_Player is an Open Source software used to view 3d models (OBJ Format)

Group: Graphics
License: GPLv2+
Url: https://github.com/alon/GLC_Player

Source: %name-%version.tar
Source1: glc_player.desktop
Patch: GLC_Player_src_2.3.0-cache.patch
Patch1: GLC_Player_src_2.3.0-prefix.patch

BuildRequires: GLC_lib-devel >= 3.0.1
BuildRequires: desktop-file-utils

# GLC_Lib not available for %arm
ExcludeArch: %arm

%description
GLC_Player is an Open Source software used to view 3d models (OBJ Format).
With the session concept and navigation possibilities GLC_Player is the
accurate tools to review a lot of 3D models. GLC_Player is a
cross-platform, Qt 5 and GLC_lib application.

%prep
%setup
%patch0 -p1 -b .cache
#patch1 -p1 -b .prefix

%build
%qmake_qt5 glc_player.pro
%make_build

%install
mkdir -p %buildroot%_bindir
install -pm 0755 glc_player %buildroot%_bindir

mkdir -p %buildroot%_datadir/{applications,pixmaps}

install -pm 0644 ressources/images/GLC_logo_blanc.png \
%buildroot%_pixmapsdir/glc_player.png

desktop-file-install \
  --dir %buildroot%_desktopdir \
  --mode 644 \
%SOURCE1

# Register as an application to be visible in the software center
#
# NOTE: It would be *awesome* if this file was maintained by the upstream
# project, translated and installed into the right place during `make install`.
#
# See http://www.freedesktop.org/software/appstream/docs/ for more details.
#
mkdir -p %buildroot%_datadir/appdata
cat > %buildroot%_datadir/appdata/glc_player.appdata.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2014 Ryan Lerch <rlerch@redhat.com> -->
<!--
EmailAddress: laumaya@users.sourceforge.net
SentUpstream: 2014-09-17
-->
<application>
  <id type="desktop">glc_player.desktop</id>
  <metadata_license>CC0-1.0</metadata_license>
  <summary>View 3D models</summary>
  <description>
  <p>
    GLC Player is an application for viewing 3D models.
    It supports a wide range of formats, including:  COLLADA, 3DXML, OBJ,
    3DS, STL, OFF and COFF.
    It can also be used to export still images of your models, and even
    export a library of models to a gallery HTML page.
  </p>
  </description>
  <url type="homepage">http://www.glc-player.net/</url>
  <screenshots>
    <screenshot type="default">http://www.glc-player.net/images/Lin_corsair_full.jpg</screenshot>
  </screenshots>
</application>
EOF

%files
%doc
%_bindir/glc_player
%_pixmapsdir/glc_player.png
%_datadir/appdata/*.appdata.xml
%_desktopdir/*.desktop

%changelog
