Name: GeoIP-Lite-Country
Version: 20180327
Release: alt1
# OK, day designation in version string is unneeded, this file updates strictly
# monthly. We need to introduce Epoch in order to drop day from version
Epoch: 1

Packager: Victor Forsiuk <force@altlinux.org>

Summary: GeoLite Country database file
License: OPEN DATA LICENSE (see LICENSE.txt)
Group: System/Libraries

Url: http://www.maxmind.com/app/geolitecountry
Source: http://geolite.maxmind.com/download/geoip/database/GeoLiteCountry/GeoIP.dat.gz
Source1: GeoIP-data-LICENSE.txt

BuildArch: noarch

Requires: libGeoIP > 1.4.2-alt1

# Need to do it explicitly...
Provides: /usr/share/GeoIP/GeoIP.dat

%description
This package contain the free edition country database for GeoIP. This
database simply contains IP blocks as keys, and countries as values. It
should be more complete and accurate than using reverse DNS lookups.

%prep
%setup -T -c

%build
cp %SOURCE1 ./LICENSE.txt

%install
install -d %buildroot%_datadir/GeoIP
gunzip -c %_sourcedir/GeoIP.dat.gz >%buildroot%_datadir/GeoIP/GeoIP.dat

%files
%doc LICENSE.txt
%dir %_datadir/GeoIP/
%config(noreplace) %_datadir/GeoIP/GeoIP.dat

# Why mark DB as config(noreplace)? User can update GeoIP.dat directly
# fetching file from MaxMind site via monthly cron job. In such case
# this package may actually overwrite freshly downloaded DB with older
# version. We mark file norepace in order to prevent rpm from doing this.

%changelog
