%define oname libressl
%define libcrypto_sover 50
%define libssl_sover 53
%define libtls_sover 26

# to avoid colission with OpenSSL pkgconfig provides
%filter_from_provides /^pkgconfig(libcrypto)/d
%filter_from_provides /^pkgconfig(libssl)/d
%filter_from_provides /^pkgconfig(openssl)/d
%filter_from_requires /^pkgconfig(libcrypto)/d
%filter_from_requires /^pkgconfig(libssl)/d

Name: LibreSSL
Version: 3.7.3
Release: alt1

Summary: OpenBSD fork of OpenSSL library

# the code is distributed under ISC license except of original OpenSSL code
License: ISC and OpenSSL
Group: Security/Networking
Url: http://www.libressl.org/

# repacked http://ftp.openbsd.org/pub/OpenBSD/LibreSSL/%oname-%version.tar.gz
Source: %oname-%version.tar
Source1: %name.watch
Source2: upstream-signing-key.asc

Patch1: 0001-ALT-netcat-execcmd.patch
Patch2: 0002-ALT-netcat-proxy_pass.patch
Patch3: 0003-ALT-netcat-usage.patch
Patch4: 0004-ALT-openssl-manpage.patch
Patch5: 0005-ALT-OPENSSLDIR.patch
Patch6: 0006-SUSE-des-fcrypt.patch
Patch7: 0007-SUSE-extra-symver.patch
Patch8: 0008-ALT-netcat-fix-linkage-with-libcrypto.patch
Patch9: 0009-ALT-TLS_DEFAULT_CA_FILE-and-cert.pem.patch

%define common_descr \
LibreSSL is a version of the TLS/crypto stack forked from OpenSSL in\
2014, with goals of modernizing the codebase, improving security, and\
applying best practice development processes.

%description
%common_descr

%package -n openssl-LibreSSL
Summary: LibreSSL openssl utility, which provides tools for managing keys, certificates, etc
Group: Security/Networking
Obsoletes: LibreSSL-openssl

%description -n openssl-LibreSSL
%common_descr

This package contains openssl(1) utility.

%package devel
Summary: Headers for %name
Group: Development/C
Conflicts: libcrypto-devel libssl-devel

%description devel
%common_descr

Headers for building software that uses %name

%package devel-doc
Obsoletes: %name-doc
Summary: Documantation pages for %name
Group: Documentation
BuildArch: noarch
Conflicts: openssl-doc

%description devel-doc
%common_descr

This package contains documantation pages for %name

%package -n libcrypto%libcrypto_sover
Summary: LibreSSL libcrypto shared library
Group: Security/Networking
# Files conflict
Conflicts: libcrypto45 libcrypto46 libcrypto47
Obsoletes: libcrypto-LibreSSL < %version

%description -n libcrypto%libcrypto_sover
%common_descr

LibreSSL libcrypto shared library

%package -n libssl%libssl_sover
Summary: LibreSSL libssl shared library
Group: Security/Networking
Obsoletes: libssl-LibreSSL < %version

%description -n libssl%libssl_sover
%common_descr

LibreSSL libssl shared library

%package -n libtls%libtls_sover
Summary: TLS library from LibreSSL
Group: Security/Networking
Requires: %_sysconfdir/%oname

%description -n libtls%libtls_sover
%common_descr

A new TLS library, designed to make it easier to write foolproof
applications.

%package -n libtls-devel
Summary: Headers for libtls
Group: Development/C
Requires: libtls%libtls_sover = %EVR
Requires: %name-devel = %EVR

%description -n libtls-devel
%common_descr

A new TLS library, designed to make it easier to write foolproof
applications.

Headers for building software that uses libtls

%package -n libtls-devel-doc
Obsoletes: libtls-doc
Summary: Manpages for libtls
Group: Documentation
BuildArch: noarch

%description -n libtls-devel-doc

%common_descr

A new TLS library, designed to make it easier to write foolproof
applications.

Thins package contains manual pages for libtls

%package -n ocspcheck
Summary: utility to validate a certificate
Group: Security/Networking

%description -n ocspcheck
utility to validate a certificate against its OCSP responder and save the reply
for stapling

%package -n netcat-tls
Summary: Reads and writes data across network connections using TCP or UDP
Group: Networking/Other
License: BSD
Obsoletes: netcat-openbsd
Conflicts: netcat
Provides: nc
Provides: netcat
Provides: netcat-ssl

%description -n netcat-tls
The nc (or netcat) utility is used for just about anything under the sun
involving TCP, UDP, or UNIX-domain sockets.  It can open TCP connections,
send UDP packets, listen on arbitrary TCP and UDP ports, do port scanning,
and deal with both IPv4 and IPv6.  Unlike telnet(1), nc scripts nicely, and
separates error messages onto standard error instead of sending them to
standard output, as telnet(1) does with some.

Common uses include:

      o   simple TCP proxies
      o   shell-script based HTTP clients and servers
      o   network daemon testing
      o   a SOCKS or HTTP ProxyCommand for ssh(1)
      o   and much, much more

%prep
%setup -n %oname-%version
%autopatch -p2

%build
%autoreconf
%configure \
	--disable-static \
	--disable-tests \
	--enable-nc \
	--with-openssldir='%_sysconfdir/%oname' \
	#
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_var/lib/libressl
ln -s -r %buildroot%_datadir/ca-certificates/ca-bundle.crt \
	%buildroot%_var/lib/libressl/cert.pem

pushd %buildroot%_bindir
	mv openssl{,-LibreSSL}
	ln -s nc netcat
popd

install -m 0644 -pD apps/nc/nc.1 %buildroot%_man1dir/nc.1
install -m 0644 -pD apps/ocspcheck/ocspcheck.8 %buildroot%_man8dir/ocspcheck.8

# fix manpages
pushd %buildroot%_mandir
	for nc_manpage in man1/nc.1; do
		netcat_manpage=$(echo $nc_manpage | sed -e 's/nc/netcat/')
		cp -a $nc_manpage $netcat_manpage
	done

	for openssl_manpage in man1/openssl.1 man5/openssl.cnf.5; do
		openssl_LibreSSL_manpage=$(echo $openssl_manpage | sed -e 's/\(openssl\)/\1-LibreSSL/')
		mv $openssl_manpage $openssl_LibreSSL_manpage
	done

	mv man5/x509v3{,-LibreSSL}.cnf.5
popd

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm 644 ChangeLog COPYING \
	%buildroot%docdir
xz %buildroot%docdir/ChangeLog

%files -n openssl-LibreSSL
%dir %docdir
%_bindir/openssl-LibreSSL
%_man1dir/openssl-LibreSSL.1*
%_man5dir/x509v3-LibreSSL.cnf.5*

%files devel
%_includedir/openssl
%_libdir/*.so
%_pkgconfigdir/*.pc
%exclude %_libdir/libtls.so
%exclude %_pkgconfigdir/libtls.pc

%files devel-doc
%_man3dir/*
%exclude %_man3dir/tls_*

%files -n libcrypto%libcrypto_sover
%dir %docdir
%doc %docdir/*

%dir %_sysconfdir/%oname/
%config(noreplace) %_sysconfdir/%oname/openssl.cnf
%config(noreplace) %_sysconfdir/%oname/x509v3.cnf
%_sysconfdir/%oname/*
%_man5dir/openssl-LibreSSL.cnf.5*
%_libdir/libcrypto.so.%libcrypto_sover
%_libdir/libcrypto.so.%libcrypto_sover.*
%_var/lib/libressl/cert.pem

%files -n libssl%libssl_sover
%dir %docdir
%_libdir/libssl.so.%libssl_sover
%_libdir/libssl.so.%libssl_sover.*

%files -n ocspcheck
%_bindir/ocspcheck
%_man8dir/ocspcheck.8*

%files -n libtls%libtls_sover
%dir %docdir
%_libdir/libtls.so.%libtls_sover
%_libdir/libtls.so.%libtls_sover.*

%files -n libtls-devel
%_includedir/tls.h
%_libdir/libtls.so
%_pkgconfigdir/libtls.pc

%files -n libtls-devel-doc
%_man3dir/tls_*

%files -n netcat-tls
%_bindir/nc
%_bindir/netcat
%_man1dir/nc.1*
%_man1dir/netcat.1*

%changelog
