%define _unpackaged_files_terminate_build 1

%define soname 1.8

Name: alembic
Version: 1.8.2
Release: alt1
Summary: Open framework for storing and sharing scene data
Group: Graphics
License: BSD-3-Clause and BSL-1.0
URL: https://www.alembic.io

# https://github.com/alembic/alembic.git
Source: %name-%version.tar

# Patches from Gentoo
Patch1: alembic-1.7.11-gentoo-0002-Find-IlmBase-by-setting-a-proper-ILMBASE_ROOT-value.patch
Patch2: alembic-1.8.0-gentoo-0001-set-correct-libdir.patch

BuildRequires: boost-devel
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libhdf5-devel

# Per https://github.com/alembic/alembic/blob/master/README.txt
# alembic actually needs ilmbase, not OpenEXR.
BuildRequires: ilmbase-devel
BuildRequires: pkgconfig(zlib)

%description
Alembic is an open computer graphics interchange framework. Alembic distills
complex, animated scenes into a non-procedural, application-independent set of
baked geometric results. This 'distillation' of scenes into baked geometry is
exactly analogous to the distillation of lighting and rendering scenes into
rendered image data.

%package -n lib%name%soname
Summary: Core Alembic libraries
Group: System/Libraries

%description -n lib%name%soname
Alembic is an open computer graphics interchange framework. Alembic distills
complex, animated scenes into a non-procedural, application-independent set of
baked geometric results. This 'distillation' of scenes into baked geometry is
exactly analogous to the distillation of lighting and rendering scenes into
rendered image data.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR

%description devel
The %{name}-devel package contains libraries and header files for developing
applications that use %{name}.

%prep
%setup
%patch1 -p1
%patch2 -p1

iconv -f iso8859-1 -t utf-8 ACKNOWLEDGEMENTS.txt > ACKNOWLEDGEMENTS.txt.conv && \
	mv -f ACKNOWLEDGEMENTS.txt.conv ACKNOWLEDGEMENTS.txt

%build
%cmake \
	%_cmake_skip_rpath \
	-DALEMBIC_LIB_INSTALL_DIR=%_libdir \
	-DALEMBIC_BUILD_LIBS:BOOL=ON \
	-DALEMBIC_SHARED_LIBS=ON \
	-DDOCS_PATH:BOOL=OFF \
	-DUSE_ARNOLD:BOOL=OFF \
	-DUSE_BINARIES=ON \
	-DUSE_HDF5=ON \
	-DUSE_EXAMPLES=ON \
	-DUSE_MAYA:BOOL=OFF \
	-DUSE_PRMAN:BOOL=OFF \
	-DUSE_PYALEMBIC=OFF \
	-DUSE_STATIC_BOOST=OFF \
	-DUSE_STATIC_HDF5=OFF \
	-DUSE_TESTS=ON \
	%nil

%cmake_build

%install
%cmakeinstall_std

%files
%_bindir/abcconvert
%_bindir/abcdiff
%_bindir/abcecho
%_bindir/abcechobounds
%_bindir/abcls
%_bindir/abcstitcher
%_bindir/abctree

%files -n lib%name%soname
%doc LICENSE.txt
%doc ACKNOWLEDGEMENTS.txt FEEDBACK.txt NEWS.txt README.txt
%_libdir/libAlembic.so.%{soname}
%_libdir/libAlembic.so.%{soname}.*

%files devel
%_includedir/Alembic
%_libdir/cmake/Alembic
%_libdir/libAlembic.so

%changelog
