%define rname ansible

Name: ansible-core
Summary: A radically simple IT automation system
Version: 2.15.9
Release: alt0.p10.1

Group:   System/Configuration/Other
License: GPL-3.0
Source0: %rname-%version.tar
Source1: apt_rpm.py
Source2: apt_repo.py
Source3: ansible.cfg

Url: http://www.ansible.com

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildArch: noarch
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-six
BuildRequires: python3-module-setuptools
BuildRequires: asciidoc-a2x
BuildRequires: python3-module-jinja2
BuildRequires: python3-module-yaml
BuildRequires: python-modules-json
BuildRequires: python3-module-packaging
BuildRequires: python3-module-docutils
BuildRequires: python3-module-straight-plugin
BuildRequires: python3-module-resolvelib
BuildRequires: python3-module-wheel

Requires: ca-certificates >= 2015.10.29
%py3_requires yaml
%py3_requires paramiko
%py3_requires resolvelib
# Needed for python3 < 3.10
%py3_requires importlib_resources

# Skip findreq on all modules:
%add_findreq_skiplist %python3_sitelibdir/%rname/modules/*
%add_findreq_skiplist %python3_sitelibdir/%rname/plugins/*
%add_findreq_skiplist %python3_sitelibdir/%rname/module_utils/ansible_tower.py

# Do not provide ansible.* because ansible-core conflicts with ansible
AutoProv: yes,nopython3
%filter_from_requires /python3(ansible\./d
%filter_from_requires /yum/d

Conflicts: ansible

%description
Ansible is a radically simple model-driven configuration management,
multi-node deployment, and remote task execution system. Ansible works
over SSH and does not require any software or daemons to be installed
on remote nodes. Extension modules can be written in any language and
are transferred to managed machines automatically.

%prep
%setup -n %rname-%version
grep -Rl '^#!.*python$' * | xargs subst 's|^#!.*python$|#!%__python3|'
cp %SOURCE1 lib/ansible/modules/apt_rpm.py
cp %SOURCE2 lib/ansible/modules/apt_repo.py

%build
%pyproject_build

%install
%pyproject_install
install -Dpm 0644 %SOURCE3 %buildroot%_sysconfdir/%rname/ansible.cfg
touch %buildroot%_sysconfdir/%rname/hosts

# Fix shebangs
rm -f %buildroot%_bindir/ansible-test
rm -rf %buildroot%python3_sitelibdir/ansible_test

%files
%doc README.md changelogs/CHANGELOG-v*.rst
%_bindir/%{rname}*
%config(noreplace) %_sysconfdir/%rname
%python3_sitelibdir/%{rname}*

%changelog
