
# Upstream issue: https://github.com/apitrace/apitrace/issues/258
# Fedora
# Filter GLIBC_PRIVATE Requires, see wrappers/dlsym.cpp
#define __filter_GLIBC_PRIVATE 1

# ROSA
# Exclude libc.so.6(GLIBC_PRIVATE) because it's not provided.
#define __noautoreq '(.*)GLIBC_PRIVATE(.*)'

# ALT as in http://www.sisyphus.ru/en/srpm/Sisyphus/gcc7/spec
# Allow use __libc_dlsym and __libc_dlopen_mode
%filter_from_requires /^libc.so.6(GLIBC_PRIVATE)/d

Name: apitrace
Version: 10.0
Release: alt1

Summary: Tools for tracing OpenGL

License: MIT
Group: Graphics
Url: http://apitrace.github.io/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://github.com/apitrace/apitrace/archive/%version/apitrace-%version.tar
Source1: qapitrace.desktop
Source2: qapitrace.appdata.xml

# Unbundle gtest
Patch: apitrace-7.1_gtest.patch
Patch1: apitrace-unbundle-brotli.patch
Patch2: apitrace-gcc10.patch

# due https://bugzilla.altlinux.org/show_bug.cgi?id=35067
%remove_optflags -O2
%add_optflags -O1

# internal
%add_python3_req_skip highlight

BuildRequires: cmake ctest rpm-macros-cmake
BuildRequires: libpng-devel libbrotli-devel
BuildRequires: libsnappy-devel
BuildRequires: desktop-file-utils
#BuildRequires: libappstream-glib
BuildRequires: libgtest-devel
BuildRequires: libdwarf-devel libprocps-devel

# for gui tools
BuildRequires: libX11-devel
BuildRequires: qt5-base-devel

BuildRequires(pre): rpm-build-python3

#Requires: %name-libs = %version-%release
# scripts/snapdiff.py
#Requires: python-module-pillow

# See http://fedoraproject.org/wiki/Packaging:No_Bundled_Libraries#Packages_granted_exceptions
#Provides: bundled(md5-plumb)
# See https://fedorahosted.org/fpc/ticket/429
#Provides: bundled(libbacktrace)

%description
apitrace consists of a set of tools to:
 * trace OpenGL and OpenGL ES  APIs calls to a file;
 * replay OpenGL and OpenGL ES calls from a file
 * inspect OpenGL state at any call while retracing
 * visualize and edit trace files

%package -n lib%name
Summary: Libraries used by apitrace
Requires: %name = %version-%release
Group: Graphics

%description -n lib%name
Libraries used by apitrace

%package gui
Summary: Graphical frontend for apitrace
Requires: %name = %version-%release
Group: Graphics

%description gui
This package contains qapitrace, the Graphical frontend for apitrace.

%prep
%setup
%patch1 -p1
#patch2 -p1
# fix WRAPPER_DIR
%__subst "s|dpkg-architecture|no-dpkg-architecture|" CMakeLists.txt

# https://bugzilla.redhat.com/show_bug.cgi?id=1507659
# Remove bundled libraries, except khronos headers and libbacktrace
rm -rf `ls -1d thirdparty/* | grep -Ev "(khronos|md5|libbacktrace|crc32c)"`

# Fix spurious-executable-perm
chmod -x retrace/glretrace_main.cpp

sed -i '1i #!/usr/bin/env python3' scripts/highlight.py

%build
%cmake_insource -DENABLE_STATIC_SNAPPY=OFF -DENABLE_STATIC_LIBSTDCXX=OFF -DENABLE_STATIC_LIBGCC=OFF
%make_build

%install
%makeinstall_std

# Install doc through %%doc
rm -rf %buildroot%_docdir/

# Install desktop file
desktop-file-install --dir=%buildroot%_desktopdir/ %SOURCE1

# Install appdata file
install -Dpm 0644 %SOURCE2 %buildroot%_datadir/appdata/qapitrace.appdata.xml
#%_bindir/appstream-util validate-relax --nonet %buildroot%_datadir/appdata/qapitrace.appdata.xml

# highlight.py is not a script
#chmod 0644 %buildroot%_libdir/%name/scripts/highlight.py

%check
make check

#post gui
#_bindir/update-desktop-database &> /dev/null || :

#postun gui
#_bindir/update-desktop-database &> /dev/null || :

%files
%doc LICENSE
%doc README.markdown docs/*
%_bindir/apitrace
%_bindir/eglretrace
%_bindir/glretrace

#files -n lib%name
%_libdir/%name/

%files gui
%_bindir/qapitrace
%_desktopdir/qapitrace.desktop
%_datadir/appdata/qapitrace.appdata.xml

%changelog
