Name: apmd
Version: 3.2.2
Release: alt8
Epoch: 1
%define subver 3

#  Devel-static is omitted by default,
#  but may be overridden using 'rpmbuid --with static ...'
%def_without static

Summary: Advanced Power Management (APM) BIOS utilities for laptops
License: GPL
Group: System/Servers

Url: ftp://ftp.debian.org/debian/pool/main/a/%name
Source0: %url/%{name}_%version.orig.tar.gz
Source1: apmd.init
Source2: apmd_proxy
Source3: apmd.conf
Source4: apmd.README.ALT
Patch1: %url/%{name}_%version-%subver.diff.gz
Patch2: %name-3.2.1-alt-makefile.patch
Patch3: %name-3.2.1-alt-doc.patch
Patch4: %name-3.2.1-alt-fixes.patch
Patch5: apmd-3.2.2-pld-libtool.patch
Patch10: apmd-3.2.2-mageia-lib64.patch
Patch11: apmd-3.2.2-mageia-graphicswitch.patch

Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Wed May 13 2009
BuildRequires: libXaw-devel libXext-devel

Requires: libapm = %{?epoch:%epoch:}%version-%release
PreReq: powermgmt-base
Requires(post): %post_service
Requires(preun): %preun_service

Summary(ru_RU.UTF-8): Утилиты управления системой питания (APM BIOS)

%package -n xapm
Summary: The X11 utility that displays APM BIOS information
Summary(ru_RU.UTF-8): Графическая утилита для показа информации BIOS об APM
Group: System/XFree86
Requires: %name = %{?epoch:%epoch:}%version-%release
Provides: %name-x11 = %version-%release
Obsoletes: %name-x11

%package -n libapm
Summary: The shared library for interacting with the kernel APM driver
Summary(ru_RU.UTF-8): Библиотека для взаимодействия с APM-драйвером ядра
Group: System/Libraries

%package -n libapm-devel
Summary: The development library and header files for APM
Summary(ru_RU.UTF-8): Средства разработки для доступа к APM
Group: Development/C
Requires: libapm = %{?epoch:%epoch:}%version-%release
Provides: apmd-devel = %version-%release
Obsoletes: apmd-devel

%if_with static
%package -n libapm-devel-static
Summary: The development library for linking APM access functions statically
Summary(ru_RU.UTF-8): Статическая библиотека для работы с APM
Group: Development/C
Requires: libapm-devel = %{?epoch:%epoch:}%version-%release
%endif

%description
On laptop computers, the Advanced Power Management (APM) support provides
access to battery status information and may help you to conserve
battery power, depending on your laptop and the APM implementation.
The apmd program also lets you run arbitrary programs when APM events
happen (for example, you can eject PCMCIA devices when you suspend,
or change hard drive timeouts when you connect the battery).

This package contains apmd(8), a daemon for logging and acting on APM
events; and apm(1), a client that prints the information in /proc/apm
in a readable format.

%description -l ru_RU.UTF-8
На портативных компьютерах функции расширенного управления питанием
(Advanced Power Management, APM) служат для доступа к информации
о состоянии батареи и управления режимом энергопотребления.

Данный пакет содержит apmd(8), демон для протоколирования и реакции
на исходящие от APM события, а также консольную утилиту apm(1)
для распечатки информации из /proc/apm в читабельном виде.

Примерами реакции на APM-события могут служить отключение PCMCIA-устройств
при переходе в спящий режим или увеличение таймаута бездействия диска
при подключении дополнительной батареи.

%description -n xapm
On laptop computers, the Advanced Power Management (APM) support provides
access to battery status information and may help you to conserve battery
power, depending on your laptop and the APM implementation.

This package contains xapm(1), an X11 utility that displays APM BIOS
information.

%description -n xapm -l ru_RU.UTF-8
На портативных компьютерах функции расширенного управления питанием
(Advanced Power Management, APM) служат для доступа к информации
о состоянии батареи и управления режимом энергопотребления.

Данный пакет содержит xapm, утилиту для показа состояния APM
в графическом режиме.

%description -n libapm
On laptop computers, the Advanced Power Management (APM) support provides
access to battery status information and may help you to conserve battery
power, depending on your laptop and the APM implementation.

This package contains a shared library that provides support for
interacting with the APM driver in the kernel.

%description -n libapm -l ru_RU.UTF-8
На портативных компьютерах функции расширенного управления питанием
(Advanced Power Management, APM) служат для доступа к информации
о состоянии батареи и управления режимом энергопотребления.

Данный пакет содержит динамическую разделяемую библиотеку,
через которую программы осуществляют взаимодействие с драйвером APM,
расположенным в ядре.

%description -n libapm-devel
On laptop computers, the Advanced Power Management (APM) support provides
access to battery status information and may help you to conserve battery
power, depending on your laptop and the APM implementation.

This package contains a library and header files needed to write programs
that interact with the APM driver in the kernel.

%description -n libapm-devel -l ru_RU.UTF-8
На портативных компьютерах функции расширенного управления питанием
(Advanced Power Management, APM) служат для доступа к информации
о состоянии батареи и управления режимом энергопотребления.

Данный пакет содержит заголовочные файлы и подсказки, необходимые
для разработки и сборки программ, использующих библиотеку доступа
к функциям драйвера APM.

%if_with static

%description -n libapm-devel-static
On laptop computers, the Advanced Power Management (APM) support provides
access to battery status information and may help you to conserve battery
power, depending on your laptop and the APM implementation.

This package contains a library needed to static linking programs
that interact with the APM driver in the kernel.

%description -n libapm-devel-static -l ru_RU.UTF-8
На портативных компьютерах функции расширенного управления питанием
(Advanced Power Management, APM) служат для доступа к информации
о состоянии батареи и управления режимом энергопотребления.

Данный пакет содержит библиотеку для статической компоновки программ,
использующих APM.

%endif

%prep
%setup -q -n %name-%version.orig
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch10 -p1
# TODO: review and apply or reject
#patch11 -p1

install -p -m644 %SOURCE4 README.ALT
echo "LIB = %_lib" > config.make

%build
#make_build
make

%install
mkdir -p %buildroot%_mandir/man{1,8}
%make_install install DESTDIR=%buildroot
install -p -m644 {apm,apmsleep,xapm}.1 %buildroot%_man1dir/
install -p -m644 apmd.8 %buildroot%_man8dir/
install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m755 %SOURCE2 %buildroot%_sysconfdir/apm/apmd_proxy
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/%name

%post
%post_service apmd

%preun
%preun_service apmd

%files
%_sbindir/*
%_bindir/*
%exclude %_bindir/xapm
%_mandir/man?/*
%exclude %_man1dir/xapm.*
%config %_initdir/%name
%config %_sysconfdir/apm/apmd_proxy
%config(noreplace) %_sysconfdir/sysconfig/%name
%doc AUTHORS ChangeLog LSM *README*

%files -n xapm
%_bindir/xapm
%_man1dir/xapm.*

%files -n libapm
%_libdir/*.so.*

%files -n libapm-devel
%_libdir/*.so
%_includedir/*

%if_with static
%files -n libapm-devel-static
%_libdir/libapm.a
%else
%exclude %_libdir/libapm.a
%endif

%changelog
