# due to sysv-systemd conflict we should not have systemd deps
%filter_from_requires /^.usr.bin.systemctl/d

# simplified backport to older branches
%define _systemddir /usr/lib/systemd

Name: atop
Version: 2.11.1
Release: alt1.1
Summary: AT Computing's System & Process Monitor
License: GPLv2+
Group: Monitoring
URL: https://www.atoptool.nl
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: rpm-build-python3
BuildRequires: libncursesw-devel zlib-devel glib2-devel libjson-c-devel

%description
%name is an interactive monitor to view the load on a Linux-system. It shows the
occupation of the most critical hardware-resources (from a performance point of
view) on system-level, i.e. cpu, memory, disk and network. It also shows which
processes are responsible for the indicated load (again cpu-, memory-, disk- and
network-load on process-level).
The program can also be used to log system- and process-level information in raw
format for long-term analysis.

%prep
%setup
%patch -p1
%ifarch %e2k
# error: cannot open source file "atop.h"
# because "CFLAGS +=" in the makefile is ignored if CFLAGS is set
%add_optflags -I.
%endif

%build
# fix build with glib2-devel
export C_INCLUDE_PATH=%_libdir/glib-2.0/include:%_includedir/glib-2.0/glib:%_includedir/glib-2.0:%_includedir/json-c:$C_INCLUDE_PATH
%make_build CFLAGS="%optflags"
gzip -c9 ChangeLog > ChangeLog.gz

%install
mkdir -p %buildroot/usr/lib/pm-utils/sleep.d %buildroot%_sysconfdir/default
for i in install sysvinstall;do
make $i DESTDIR=%buildroot INIPATH=%_initddir SYSDPATH=%_unitdir PMPATHD=%_systemddir/system-sleep
done
:> %buildroot%_sysconfdir/%{name}rc

%post
%post_service %name ||:

%preun
%preun_service %name ||:

%files
%doc ChangeLog.* README
%ghost %config(noreplace) %_sysconfdir/%{name}rc
%config(noreplace) %_sysconfdir/default/%name
%_bindir/*
%_sbindir/*
%_man1dir/*
%_man5dir/*
%_man8dir/*
%_sysconfdir/cron.d/*
# %_sysconfdir/logrotate.d/*
%_initdir/*
%_unitdir/%{name}*.service
%_unitdir/%{name}*.timer
%_logdir/%name
%_datadir/%name
%_systemddir/system-sleep/atop-pm.sh
%_prefix/lib/pm-utils/sleep.d/45atoppm

%changelog
