Group: Development/Other
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-1.8-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           avalon-framework
Epoch:          0
Version:        4.3
Release:        alt5_24jpp8
Summary:        Java components interfaces
License:        ASL 2.0
URL:            http://avalon.apache.org/
BuildArch:    	noarch

Source0:        http://archive.apache.org/dist/excalibur/avalon-framework/source/%{name}-api-%{version}-src.tar.gz
Source1:        http://archive.apache.org/dist/excalibur/avalon-framework/source/%{name}-impl-%{version}-src.tar.gz

Patch0001:      0001-Port-build-script-to-Maven-3.patch

BuildRequires:  maven-local
BuildRequires:  mvn(avalon-logkit:avalon-logkit)
BuildRequires:  mvn(commons-logging:commons-logging)
BuildRequires:  mvn(log4j:log4j)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)

Provides:       deprecated()
Source44: import.info

%description
The Avalon framework consists of interfaces that define relationships
between commonly used application components, best-of-practice pattern
enforcements, and several lightweight convenience implementations of the
generic components.
What that means is that we define the central interface Component. We
also define the relationship (contract) a component has with peers,
ancestors and children.

%package javadoc
Group: Development/Java
Summary:        API documentation %{name}
Provides:       deprecated()
BuildArch: noarch

%description javadoc
%{summary}.

%prep
%setup -qcT
tar xvf %{SOURCE0}
tar xvf %{SOURCE1}
%patch0001 -p1

%mvn_package :aggregator __noinstall
%mvn_file ":*api*" %{name}-api
%mvn_file ":*impl*" %{name}-impl %{name}

# Add proper Apache Felix Bundle Plugin instructions
# so that we get a reasonable OSGi manifest.
for mod in api impl; do
    %pom_xpath_inject pom:project "<packaging>bundle</packaging>" *${mod}*/project.xml
    %pom_xpath_inject pom:build "
      <plugins>
        <plugin>
          <groupId>org.apache.felix</groupId>
          <artifactId>maven-bundle-plugin</artifactId>
          <extensions>true</extensions>
          <configuration>
            <instructions>
              <Bundle-SymbolicName>avalon-framework-${mod}-4.3</Bundle-SymbolicName>
              <_nouses>true</_nouses>
            </instructions>
          </configuration>
        </plugin>
      </plugins>" *${mod}*/project.xml
done

%mvn_alias 'avalon-framework:{*}' 'org.apache.avalon.framework:@1'

%build
# Test use old jmock
%mvn_build -f -j

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference avalon-framework-api-4.3/LICENSE.txt
%doc --no-dereference avalon-framework-api-4.3/NOTICE.txt

#%files javadoc -f .mfiles-javadoc
#%doc --no-dereference avalon-framework-api-4.3/LICENSE.txt
#%doc --no-dereference avalon-framework-api-4.3/NOTICE.txt

%changelog
