# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name:    blueman
Version: 2.4.6
Release: alt1

Summary: Blueman is a GTK+ Bluetooth Manager
License: GPL-3.0-or-later
Group:   System/Configuration/Hardware
URL:     https://github.com/blueman-project/blueman

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-python3
BuildRequires(pre): rpm-macros-systemd
BuildRequires: meson
BuildRequires: rpm-build-python3 rpm-build-gir
BuildRequires: python3-dev
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(pygobject-3.0)
BuildRequires: pkgconfig(bluez)
BuildRequires: pkgconfig(polkit-agent-1)
BuildRequires: intltool >= 0.35.0
BuildRequires: iproute
BuildRequires: python3-module-Cython >= 0.21
BuildRequires: python3-module-dbus

Requires: bluez
Requires: typelib(Gtk) = 3.0
# https://bugzilla.altlinux.org/52950
Requires: python3-module-pygobject3

%add_python3_req_skip gi.repository.GObject

%description
%summary.

%prep
%setup
%patch -p1

%build
%meson  -Dsystemdsystemunitdir=%_unitdir \
	-Dsystemduserunitdir=%_user_unitdir \
	-Ddhcp-config-path=%_sysconfdir/dhcp/dhcpd.conf \
	-Dthunar-sendto=false \
	-Dpolicykit=true \
	-Dpulseaudio=true \
	-Dpythoninstalldir=%python3_sitelibdir \
	-Dsendto-plugins=[]

%meson_build

%install
%meson_install

mkdir -p %buildroot%_altdir
cat > %buildroot%_altdir/%name <<EOF
%_bindir/bluetooth-sendto	%_bindir/blueman-sendto	20
EOF

# replace config
mkdir -p %buildroot%_sysconfdir/dbus-1/system.d
mv %buildroot%_datadir/dbus-1/system.d/org.blueman.Mechanism.conf \
	%buildroot%_sysconfdir/dbus-1/system.d

mkdir -p %buildroot%_presetdir
echo 'enable blueman-mechanism.service' >%buildroot%_presetdir/80-blueman.preset

%find_lang %name

%post
%post_service blueman-mechanism.service

%preun
%preun_service blueman-mechanism.service

%files -f %name.lang
%_altdir/blueman
%doc CHANGELOG.md FAQ README.md
%_bindir/blueman-*
%_unitdir/blueman-mechanism.service
%_presetdir/80-blueman.preset
%_user_unitdir/blueman-applet.service
%_user_unitdir/blueman-manager.service
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.blueman.Mechanism.conf
%_datadir/dbus-1/system-services/org.blueman.Mechanism.service
%_datadir/dbus-1/services/org.blueman.Manager.service
%_datadir/applications/blueman-*.desktop
%_datadir/dbus-1/services/org.blueman.Applet.service
%_datadir/blueman
%_datadir/glib-2.0/schemas/org.blueman.gschema.xml
%_datadir/polkit-1/actions/org.blueman.policy
%_datadir/polkit-1/rules.d/blueman.rules
%_desktopdir/blueman-manager.desktop
%_iconsdir/hicolor/*/*/*
%_libexecdir/blueman-mechanism
%_libexecdir/blueman-rfcomm-watcher
%_man1dir/blueman-*.1*
%python3_sitelibdir/blueman
%python3_sitelibdir/_blueman.so
%_sysconfdir/xdg/autostart/blueman.desktop

%changelog
