%ifdef _priority_distbranch
%define altbranch %_priority_distbranch
%else
%define altbranch %(rpm --eval %%_priority_distbranch)
%endif
%if "%altbranch" == "%nil"
%define altbranch sisyphus
%endif

%ifarch %ix86 x86_64
%def_enable gfxboot
%else
%def_disable gfxboot
%endif
%def_enable flickfree

%define Theme Workstation K
%define smalltheme kworkstation
%define codename Sorbaronia Mitschurinii
%define brand alt
%define Brand ALT
%define fakebrand xalt

%define major 10
%define minor 4
%define bugfix 0
%define altversion %major.%minor
%define altmajor %major

Name: branding-%fakebrand-%smalltheme
Version: %major.%minor.%bugfix
Release: alt1

%define theme %name
%define design_graphics_abi_epoch 0
%define design_graphics_abi_major 12
%define design_graphics_abi_minor 1
%define design_graphics_abi_bugfix 1

BuildRequires: fonts-ttf-dejavu fonts-ttf-google-droid-sans
BuildRequires: design-bootloader-source >= 5.0-alt2
BuildRequires: cpio %{?_enable_gfxboot:gfxboot >= 4}

BuildRequires: libalternatives-devel
BuildRequires: qt5-base-devel
BuildRequires: ImageMagick fontconfig bc libGConf-devel /usr/bin/fribidi

%define Theme_ru Рабочая станция К
%define Brand_ru Альт
%define status %nil
%define status_ru %nil
%define ProductName %Brand %Theme %altversion
%define ProductName_ru %Brand_ru %Theme_ru %altversion
%define branding_data_dir %_datadir/branding-data-current

%define variants alt-kdesktop alt-server alt-starterkit alt-workstation altlinux-kdesktop altlinux-desktop altlinux-office-desktop altlinux-office-server altlinux-lite altlinux-workbench altlinux-sisyphus sisyphus-server school-master school-server school-teacher school-lite school-junior altlinux-gnome-desktop sisyphus-server-light

%define grub_normal light-gray/black
%define grub_high white/dark-gray

Source: %name.tar

Group: Graphics
Summary: System/Base
License: GPL
Url: https://www.basealt.ru/

%description
Distro-specific packages with design and texts


%package bootloader
Group: System/Configuration/Boot and Init
Summary: Graphical boot logo for grub2, lilo and syslinux
License: GPL
Requires(pre): coreutils
Requires(pre): /etc/sysconfig/i18n
Provides: design-bootloader-system-%theme design-bootloader-livecd-%theme design-bootloader-livecd-%theme design-bootloader-%theme branding-alt-%theme-bootloader
Obsoletes: design-bootloader-system-%theme design-bootloader-livecd-%theme design-bootloader-livecd-%theme design-bootloader-%theme branding-alt-%theme-bootloader
%description bootloader
Here you find the graphical boot logo. Suitable for both lilo and syslinux.

%package bootsplash
BuildArch: noarch
Summary: Theme for splash animations during bootup
License: Distributable
Group:  System/Configuration/Boot and Init
Provides: plymouth-theme-%theme plymouth(system-theme)
%if_enabled flickfree
%define plymouth_theme bgrt-alt
Requires: plymouth-theme-bgrt-alt
%else
%define plymouth_theme %theme
%endif
Requires: plymouth-plugin-script
Requires: plymouth-plugin-label
Requires: fonts-ttf-dejavu
Requires(pre,postun): plymouth
%description bootsplash
This package contains graphics for boot process, displayed via Plymouth


%package alterator
BuildArch: noarch
Summary: Design for alterator for %Brand %Theme 
License: GPL
Group: System/Configuration/Other
Provides: design-alterator-browser-%theme  branding-alt-%theme-browser-qt branding-altlinux-%theme-browser-qt
Provides: alterator-icons design-alterator design-alterator-%theme
Obsoletes:  branding-alt-%theme-browser-qt  branding-altlinux-%theme-browser-qt 
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-alterator ";done )
Obsoletes: design-alterator-server design-alterator-desktop design-altertor-browser-desktop  design-altertor-browser-server 
Requires: alternatives >= 0.2 alterator
%description alterator
Design for QT and web alterator for %Brand %Theme

%package graphics
BuildArch: noarch
Summary: design for ALT
License: Different licenses
Group: Graphics
Provides: design-graphics = %design_graphics_abi_major.%design_graphics_abi_minor.%design_graphics_abi_bugfix
Provides: design-graphics-%theme  branding-alt-%theme-graphics design-graphics-kdesktop
Obsoletes:  branding-alt-%theme-graphics design-graphics-%theme design-graphics-kdesktop
Provides: gnome-session-splash = %version-%release
Requires: alternatives >= 0.2
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-graphics ";done )
%description graphics
This package contains some graphics for ALT design.

%define provide_list altlinux fedora redhat system altlinux
%define obsolete_list altlinux-release fedora-release redhat-release
%define conflicts_list altlinux-release-sisyphus altlinux-release-4.0 altlinux-release-junior altlinux-release-master altlinux-release-server altlinux-release-terminal altlinux-release-small_business

%package release
BuildArch: noarch
Summary: %ProductName release file
License: GPL
Group: System/Configuration/Other
Requires: alt-os-release
Provides: %(for n in %provide_list; do echo -n "$n-release = %version-%release "; done) altlinux-release-%theme  branding-alt-%theme-release
Obsoletes: %obsolete_list  branding-alt-%theme-release
Conflicts: %conflicts_list
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-release ";done )
%description release
%ProductName release file.

%package notes
BuildArch: noarch
Provides: alt-license-theme = %version alt-notes-%theme
Obsoletes: alt-license-%theme alt-notes-%theme
Summary: Distribution license and release notes
License: Distributable
Group: Documentation
Conflicts: alt-notes-children alt-notes-hpc alt-notes-junior alt-notes-junior-sj alt-notes-junior-sm alt-notes-school-server alt-notes-server-lite alt-notes-skif alt-notes-terminal 
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-notes ";done )
%description notes
Distribution license and release notes

%package kde4-settings
BuildArch: noarch
Summary: KDE4 settings for %ProductName
License: Distributable
Group: Graphical desktop/KDE
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-kde4-settings ";done )
Requires(pre,postun): %name-graphics
%description kde4-settings
KDE4 settings for %ProductName

%package fvwm-settings
BuildArch: noarch
Summary: FVWM2 settings for %ProductName
License: Distributable
Group: Graphical desktop/FVWM based
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-fvwm-settings ";done )
%description fvwm-settings
FVWM2 settings for %ProductName

%package mate-settings
BuildArch: noarch
Summary: MATE settings for %ProductName
License: Distributable
Group:   Graphical desktop/GNOME
%description mate-settings
MATE settings for %ProductName

%package gnome-settings
BuildArch: noarch
Summary: GNOME settings for %ProductName
License: Distributable
Group: Graphical desktop/GNOME
Requires(pre): /usr/bin/gconftool-2
Provides: gnome-theme-%brand-%theme = %version-%release
Provides: metacity-theme-%brand-%theme = %version-%release
Provides: metacity-theme
Provides: gnome-menus = 2.30.4
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-gnome-settings ";done )
%description gnome-settings
GNOME settings for %ProductName

%package slideshow
BuildArch: noarch
Summary: Slideshow for %ProductName installer
License: Distributable
Group: System/Configuration/Other 
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-slideshow ";done )
%description slideshow
Slideshow for %ProductName installer

%package indexhtml
#BuildArch: noarch
Summary: %name -- ALT html welcome page
License: distributable
Group: System/Base
Provides: indexhtml indexhtml-%theme = %version indexhtml-Desktop = 1:5.0
Obsoletes: indexhtml-desktop indexhtml-Desktop
Conflicts: %(for n in %variants ; do [ "$n" = %brand-%theme ] || echo -n "branding-$n-indexhtml ";done )
Requires: xdg-utils
Requires: docs-alt-%smalltheme
Requires(post): indexhtml-common
%description indexhtml
ALT index.html welcome page.

%prep
%setup -n %name

%if_enabled gfxboot
%define x86 grub boot
%else
%define x86 grub
%endif

mkdir design-bootloader-source-copy
cp -ar /usr/src/design-bootloader-source ./design-bootloader-source-copy/
sed -i 's|/usr/share/fonts/ttf/droid/|/usr/share/fonts/ttf/google-droid/|' design-bootloader-source-copy/design-bootloader-source/fonts/Makefile
sed -i 's|/usr/src/design-bootloader-source|design-bootloader-source-copy/design-bootloader-source|' components.mk

%build
autoconf
THEME=%theme \
NAME='%Theme' \
NAME_RU='%Theme_ru' \
BRAND_FNAME='%Brand' \
BRAND_FNAME_RU='%Brand_ru' \
BRAND='%brand' \
PRODUCT_NAME='%ProductName' \
PRODUCT_NAME_RU='%ProductName_ru' \
STATUS=%status \
STATUS_RU=%status_ru \
VERSION=%altversion \
X86='%x86' \
    ./configure
make

%install
%makeinstall

#graphics
mkdir -p %buildroot/%_datadir/design/{%theme,backgrounds}
cp -ar graphics/* %buildroot/%_datadir/design/%theme

pushd %buildroot/%_datadir/design/%theme
    pushd backgrounds
	ln -sf ../../../wallpapers more
    popd
popd

GRAPHICS_ALTPRIO=`printf '%%.3d%%.3d%%.3d%%.3d\n' %design_graphics_abi_epoch %design_graphics_abi_major %design_graphics_abi_minor %design_graphics_abi_bugfix`
install -d %buildroot//etc/alternatives/packages.d
cat >%buildroot/etc/alternatives/packages.d/%name-graphics <<__EOF__
%_datadir/design-current	%_datadir/design/%theme	$GRAPHICS_ALTPRIO
%_datadir/design/current	%_datadir/design/%theme	$GRAPHICS_ALTPRIO
__EOF__


# release
mkdir -p %buildroot%_sysconfdir/buildreqs/packages/ignore.d/
install -pD -m644 /dev/null %buildroot%_sysconfdir/buildreqs/packages/ignore.d/%name-release
echo "%ProductName%status (%codename)" >%buildroot%_sysconfdir/altlinux-release
for n in fedora redhat system; do
	ln -s altlinux-release %buildroot%_sysconfdir/$n-release
done
# os-release
cat >>%buildroot/%_sysconfdir/os-release <<__EOF__
NAME="%Brand"
VERSION="%altversion%status"
ID=altlinux
LOGO="basealt"
VERSION_ID=%altversion
PRETTY_NAME="%ProductName%status (%codename)"
ANSI_COLOR="1;33"
CPE_NAME="cpe:/o:%brand:%smalltheme:%altmajor"
BUILD_ID="%Brand %altversion%status"
ALT_BRANCH_ID="%altbranch"
HOME_URL="%url"
BUG_REPORT_URL="https://bugs.altlinux.org/"
DOCUMENTATION_URL="https://docs.altlinux.org/"
SUPPORT_URL="https://support.basealt.ru/"
__EOF__
# save release
mkdir -p %buildroot/%branding_data_dir/release/
cp -ar %buildroot/%_sysconfdir/altlinux-release %buildroot/%branding_data_dir/release/altlinux-release
cp -ar %buildroot/%_sysconfdir/os-release %buildroot/%branding_data_dir/release/os-release
mkdir -p %buildroot/%prefix/lib/
cp -ar %buildroot/%_sysconfdir/os-release %buildroot/%prefix/lib/os-release

#notes
pushd notes
%makeinstall
popd

#kde4-settings
pushd kde4-settings
mkdir -p %buildroot%_sysconfdir/skel/.kde4
cp -a kde4/* %buildroot%_sysconfdir/skel/.kde4/
mkdir -p %buildroot%_sysconfdir/kde4/xdg/menus/applications-merged/
install -m 0644 menu/*.menu %buildroot%_sysconfdir/kde4/xdg/menus/applications-merged/
popd
# disable annoing autostart
mkdir -p %buildroot/%_sysconfdir/skel/.config/autostart/
for n in tracker-extract tracker-miner-apps tracker-miner-fs tracker-miner-user-guides tracker-store ; do
    echo -e "[Desktop Entry]\nHidden=true" > %buildroot%_sysconfdir/skel/.config/autostart/$n.desktop
done
# disable annoing menus
mkdir -p %buildroot/%_sysconfdir/skel/.local/share/applications/
for n in gnome-mplayer mplayer gmplayer ; do
    echo -e "[Desktop Entry]\nHidden=true" > %buildroot/%_sysconfdir/skel/.local/share/applications/$n.desktop
done

#fwvm-settings
mkdir -p %buildroot/etc/skel
install -m 644 fvwm-settings/.fvwm2rc %buildroot/etc/skel/

#mate-settings
pushd mate-settings
install -m 644 -D mate-background.gschema.override %buildroot/%_datadir/glib-2.0/schemas/50_mate-%name-background.gschema.override
popd

#gnome-settings
%define XdgThemeName %Brand %Theme
pushd gnome-settings
mkdir -p '%buildroot/%_datadir/themes/%XdgThemeName'
install -m 644  panel-default-setup.entries '%buildroot/%_datadir/themes/%XdgThemeName/'
mkdir -p '%buildroot/%_datadir/themes/%XdgThemeName/gtk-2.0'
install -m 644 gtkrc '%buildroot/%_datadir/themes/%XdgThemeName/gtk-2.0'
mkdir -p '%buildroot/%_datadir/themes/%XdgThemeName/metacity-1'
install -m 644 metacity-theme-1.xml '%buildroot/%_datadir/themes/%XdgThemeName/metacity-1/'
install -m 644 index.theme '%buildroot/%_datadir/themes/%XdgThemeName/'
mkdir -p '%buildroot/etc/gnome/xdg/menus/'
install -m 644 gnome-applications.menu '%buildroot/etc/gnome/xdg/menus/'
install -m 644 settings.menu '%buildroot/etc/gnome/xdg/menus/'
install -m 644 gtkrc-2 %buildroot/etc/skel/.gtkrc-2.0
mkdir -p %buildroot/etc/skel/.config/gtk-3.0/
install -m 644 gtk3-settings.ini %buildroot/etc/skel/.config/gtk-3.0/settings.ini
popd

#slideshow
mkdir -p %buildroot/usr/share/install2/slideshow
install -m 0644 slideshow/*  %buildroot/usr/share/install2/slideshow/


%if_enabled gfxboot
%pre bootloader
[ -s /usr/share/gfxboot/%theme ] && rm -fr  /usr/share/gfxboot/%theme ||:
[ -s /boot/splash/%theme ] && rm -fr  /boot/splash/%theme ||:
%endif

%post bootloader
%if_enabled gfxboot
%__ln_s -nf %theme/message /boot/splash/message
. /etc/sysconfig/i18n
lang=$(echo $LANG | cut -d. -f 1)
cd boot/splash/%theme/
echo $lang > lang
[ "$lang" = "C" ] || echo lang | cpio -o --append -F message
%endif
. shell-config
shell_config_set /etc/sysconfig/grub2 GRUB_COLOR_NORMAL %grub_normal
shell_config_set /etc/sysconfig/grub2 GRUB_COLOR_HIGHLIGHT %grub_high
%if_enabled flickfree
shell_config_del /etc/sysconfig/grub2 GRUB_THEME
shell_config_del /etc/sysconfig/grub2 GRUB_BACKGROUND
# deprecated
shell_config_del /etc/sysconfig/grub2 GRUB_WALLPAPER
%else
shell_config_set /etc/sysconfig/grub2 GRUB_THEME /boot/grub/themes/%theme/theme.txt
shell_config_set /etc/sysconfig/grub2 GRUB_BACKGROUND /boot/grub/themes/%theme/grub.png
shell_config_set /etc/sysconfig/grub2 GRUB_WALLPAPER /boot/grub/themes/%theme/grub.png
%endif

%if_enabled gfxboot
%preun bootloader
[ $1 = 0 ] || exit 0
[ "`readlink /boot/splash/message`" != "%theme/message" ] ||
    %__rm -f /boot/splash/message
%endif

%post indexhtml
%_sbindir/indexhtml-update

%post bootsplash
sed -i "s/Theme=.*/Theme=%plymouth_theme/" /etc/plymouth/plymouthd.conf ||:

%post release
# alt-os-release filetrigger do it now
#if ! [ -e %_sysconfdir/os-release ]; then
#       cp -a %branding_data_dir/release/os-release %_sysconfdir/os-release ||:
#fi

%post gnome-settings
%gconf2_set string /desktop/gnome/interface/font_name Sans 11
%gconf2_set string /desktop/gnome/interface/monospace_font_name Monospace 10
cat '/%_datadir/themes/%XdgThemeName/panel-default-setup.entries' > \
/etc/gconf/schemas/panel-default-setup.entries
/usr/bin/gconftool-2 --direct --config-source=$(/usr/bin/gconftool-2 --get-default-source) \
--load='/%_datadir/themes/%XdgThemeName/panel-default-setup.entries'
/usr/bin/gconftool-2 --direct --config-source=$(/usr/bin/gconftool-2 --get-default-source) \
--load='/%_datadir/themes/%XdgThemeName/panel-default-setup.entries' /apps/panel


%files bootloader
/boot/grub/themes/%theme
%if_enabled gfxboot
%_datadir/gfxboot/%theme
/boot/splash/%theme
%endif

%files alterator
%config %_altdir/*.rcc
/usr/share/alterator-browser-qt/design/*.rcc
/usr/share/alterator/design/*

%files graphics
%config /etc/alternatives/packages.d/%name-graphics
%_datadir/design
%_sysconfdir/skel/.config/gtk-3.0
%_sysconfdir/skel/.gtkrc-2.0
%_sysconfdir/skel/.config/autostart
%_sysconfdir/skel/.local/share/applications

%files bootsplash
%_datadir/plymouth/themes/%theme/*

%files release
%ghost %config(noreplace) %_sysconfdir/os-release
%_sysconfdir/altlinux-release
%config(noreplace) %_sysconfdir/fedora-release
%config(noreplace) %_sysconfdir/redhat-release
%config(noreplace) %_sysconfdir/system-release
%_sysconfdir/buildreqs/packages/ignore.d/*
%dir %branding_data_dir/
%dir %branding_data_dir/release/
%branding_data_dir/release/*-release
%prefix/lib/os-release

%files notes
%_datadir/alt-notes/*

%files kde4-settings
%_sysconfdir/kde4/xdg/menus/applications-merged/*.menu
%_sysconfdir/skel/.kde4

%files fvwm-settings
%_sysconfdir/skel/.fvwm2rc

%files mate-settings
%_datadir/glib-2.0/schemas/*mate*

%files gnome-settings
%_datadir/themes/*
/etc/gnome/xdg/menus/*

%files slideshow
/usr/share/install2/slideshow

%define indexhtmldir %_defaultdocdir/indexhtml

%files indexhtml
%ghost %indexhtmldir/index.html
%indexhtmldir/*
%_desktopdir/indexhtml.desktop
%_datadir/kio_desktop/DesktopLinks/indexhtml.desktop

%changelog
