%define _unpackaged_files_terminate_build 1

Name: cgal
Version: 5.0.2
Release: alt3
Summary: Easy access to efficient and reliable geometric algorithms
License: Free for non-commertial using
Group: Sciences/Mathematics
Url: https://www.cgal.org/

# https://github.com/CGAL/cgal/releases
Source: CGAL-%version.tar
Source1: CGAL-%version-doc_html.tar

BuildRequires(pre): rpm-build-python
BuildRequires: gcc-c++ gcc-fortran cmake qt5-base-devel qt5-svg-devel
BuildRequires: boost-devel libgmp-devel libgmpxx-devel eigen3
BuildRequires: libGLU-devel libGL-devel libmpfr-devel libtbb-devel
BuildRequires: zlib-devel libX11
BuildRequires: liblapack-devel

ExcludeArch: armh

%description
The goal of the CGAL Open Source Project is to provide easy access to
efficient and reliable geometric algorithms in the form of a C++
library.

%package devel
Summary: Development files of CGAL
Group: Development/C++
Conflicts: %name < %EVR
Obsoletes: %name < %EVR
Conflicts: lib%name-devel < %EVR
Obsoletes: lib%name-devel < %EVR

%description devel
The goal of the CGAL Open Source Project is to provide easy access to
efficient and reliable geometric algorithms in the form of a C++
library.

This Package contains developemnt files of CGAL.

%package devel-doc
Summary: Documentation for CGAL
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
The goal of the CGAL Open Source Project is to provide easy access to
efficient and reliable geometric algorithms in the form of a C++
library.

Thid package contains development documentation for CGAL.

%prep
%setup

%build
%cmake \
	-DCMAKE_BUILD_TYPE=Release \
	-DCGAL_INSTALL_DOC_DIR=%_defaultdocdir/%name \
	-DWITH_demos:BOOL=false \
	-DWITH_examples:BOOL=false \
	%nil

%cmake_build

%install
%cmake_install

install -d %buildroot%_docdir/%name
cp -fR doc_html %buildroot%_docdir/%name
cp -fR examples %buildroot%_docdir/%name

pushd %buildroot%_docdir/%name
tar -xf %SOURCE1
popd

%files devel
%_bindir/*
%_man1dir/*
%_includedir/*
%_libdir/cmake/CGAL

%files devel-doc
%doc %_docdir/%{name}*

%changelog
