Name: doxygen
Version: 1.9.1
Release: alt1
Epoch: 1

Summary: Doxygen is a documentation system for C, C++ and IDL
License: GPLv2+
Group: Development/Other
Url: http://www.doxygen.org/

# ftp://ftp.stack.nl/pub/users/dimitri/doxygen-%version.src.tar.gz
Source: %name-%version.src.tar.gz
Source500: %name.unused

## FC patches
Patch1: FC-doxgen-1.9.1-crash-when-parsing-config-file.patch
Patch2: FC-doxgen-1.9.1-crash-when-parsing-config-file-part2.patch
Patch3: FC-1.9.1-Coverity_issues.patch
Patch4: FC-1.9.1-crash_in_docparser.patch

## Ubuntu patches
Patch101: Ubuntu-manpages.patch
Patch102: Ubuntu-dot-config.patch
Patch103: Ubuntu-no-timestamps.patch
Patch104: Ubuntu-avoid-compass.patch
Patch105: Ubuntu-fix-pdflatex-invocation.patch
Patch106: Ubuntu-faketime_pdflatex.patch
Patch107: Ubuntu-libatomic.patch
Patch108: Ubuntu-reproducible_changelog.patch
Patch109: Ubuntu-reproducible_manpages.patch
Patch110: Ubuntu-sass_fix.patch

## ALT patches

# Automatically added by buildreq on Wed May 10 2017
# optimized out: cmake-modules fontconfig fonts-type1-urw ghostscript-classic libgpg-error libqt4-core libqt4-devel libqt4-gui libqt4-network libqt4-opengl libqt4-qt3support libqt4-script libqt4-sql-sqlite libqt4-svg libqt4-webkit-devel libqt4-xml libstdc++-devel libwayland-client libwayland-server perl python-base python-modules tex-common texlive-base texlive-base-bin texlive-common texlive-extra-utils texlive-fonts-recommended texlive-generic-recommended texlive-latex-base texlive-latex-extra texlive-latex-recommended texlive-xetex texmf-latex-xcolor xml-utils
BuildRequires: cmake flex gcc-c++ ghostscript-common graphviz qt5-base-devel python-modules-xml texlive-collection-publishers tex(tabu.sty)

%description
Doxygen is a documentation system for C, C++ and IDL.  It can generate
an on-line class browser (in HTML) and/or an off-line reference manual
(in LaTeX) from a set of documented source files.  There is also support
for generating man pages and for converting the generated output into
Postscript, hyperlinked PDF or compressed HTML.  The documentation is
extracted directly from the sources.

Doxygen can also be configured to extract the code-structure from
undocumented source files.  This can be very useful to quickly find
your way in large source distributions.

%package wizard
Summary: GUI frontend for doxygen
Group: Development/Other
Requires: %name = %epoch:%version-%release

%description wizard
Doxywizard is a GUI front-end for creating and editing
configuration files that are used by doxygen.

%package doc
Summary: Documentation and examples for doxygen
Group: Development/Other
BuildArch: noarch
Requires: %name = %epoch:%version-%release

%description doc
This package contains doxygen examples and documentation in html and
pdf formats.

%prep
%setup

## Remove junk
rm src/._xmlgen.cpp

## FC apply patches
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

## Ubuntu apply patches
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%patch105 -p1
#patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1

## ALT apply patches

%build
%define _cmake__builddir BUILD
export QTDIR=%_libdir/qt4
export PATH="$QTDIR/bin:$PATH"

%cmake -G "Unix Makefiles" \
	-Dbuild_doc=ON -Dbuild_wizard=ON -Dbuild_xmlparser=ON \
	-Dbuild_search=OFF \
	-DMAN_INSTALL_DIR=%_mandir/man1 \
	-DDOC_INSTALL_DIR=share/doc/%name-%version \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix
%cmake_build
export NPROCS=1
%cmake_build -t docs

%install
%cmakeinstall_std

%check
cd BUILD && make tests

%files
%doc README.md
%_bindir/doxygen
%_man1dir/doxygen.*

%files wizard
%_bindir/doxywizard
%_man1dir/doxywizard.*

%files doc
%_defaultdocdir/%name-%version
#exclude %_defaultdocdir/%name-%version/html
%exclude %_defaultdocdir/%name-%version/README.md
%exclude %_man1dir/doxy[is]*

%changelog
