%def_disable snapshot
%define xdg_name org.gnome.Evince

%define _libexecdir %_prefix/libexec
%define ver_major 40
%define api_ver_major 3
%define api_ver %api_ver_major.0
%define so_ver 4

%def_enable xps
%def_enable ps
%def_enable t1lib
%def_enable dbus
%def_enable introspection
%def_enable browser_plugin
%def_enable multimedia
%def_enable nautilus
%def_enable gtk_doc
%def_disable debug

Name: evince
Version: %ver_major.5
Release: alt1

Summary: A document viewer
Group: Office
License: GPL-2.0-or-later
Url: http://www.gnome.org/projects/evince/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: lib%name = %EVR
Requires: %name-data = %EVR
Requires: gnome-icon-theme gnome-icon-theme-symbolic icon-theme-adwaita
Requires: gvfs-backend-recent-files
Requires: dconf
%{?_enable_multimedia:Requires: gst-plugins-base1.0 gst-libav}

%define poppler_ver 0.33
%define gtk_ver 3.22
%define handy_ver 1.0.0
%define spectre_ver 0.2.0

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson libpoppler-glib-devel >= %poppler_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: gcc-c++ gnome-common libappstream-glib-devel yelp-tools
BuildRequires: icon-theme-adwaita libdjvu-devel libgnome-keyring-devel
BuildRequires: libspectre-devel >= %spectre_ver libtiff-devel
BuildRequires: libxml2-devel libkpathsea-devel libgail3-devel gsettings-desktop-schemas-devel
BuildRequires: zlib-devel libsecret-devel libarchive-devel libgspell-devel
BuildRequires: libgnome-desktop3-devel
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
%{?_enable_xps:BuildRequires: libgxps-devel}
%{?_enable_t1lib:BuildRequires: t1lib-devel}
%{?_enable_dbus:BuildRequires: libdbus-devel}
%{?_enable_browser_plugin:BuildRequires:browser-plugins-npapi-devel}
%{?_enable_multimedia:BuildRequires: gst-plugins1.0-devel}
%{?_enable_nautilus:BuildRequires: libnautilus-devel}
%{?_enable_introspection:
BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
BuildRequires: libXi-devel
BuildRequires: pkgconfig(systemd)

%description
Evince is a document viewer capable of displaying multiple and single page
document formats like PDF and Postscript

%package data
Summary: Arch independent files for Evince
Group: Office
BuildArch: noarch

%description data
This package provides noarch data needed for Evince to work.

%package dvi
Summary: Evince backend for dvi files
Group: Office
Requires: %name = %EVR

%description dvi
A backend to let evince display dvi files

%package -n lib%name
Summary: Library for the %name project
Group: System/Libraries

%description -n lib%name
Library for %name project

%package -n lib%name-gir
Summary: GObject introspection data for the Evince library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Evince library

%package -n lib%name-devel
Summary: Development tools for the %name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Header files for %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Evince library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the Evince library

%package -n lib%name-devel-doc
Summary: Development documentation for Evince
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
This package contains documentation necessary to develop applications
using Evince library.

%package -n mozilla-plugin-%name
Summary: Mozilla plugin for the Evince document viewer
Group: Networking/WWW
Requires: %name = %EVR
Requires: browser-plugins-npapi

%description -n mozilla-plugin-%name
A Mozilla plug-in that enables to view documents from within webpages
via the Evince.

%prep
%setup

%build
%meson \
    -Dpdf=enabled \
    -Dtiff=enabled \
    -Ddjvu=enabled \
    -Ddvi=enabled \
    %{?_disable_t1lib:-Dt1lib=disabled} \
    -Dcomics=enabled \
    %{?_disable_gtk_doc:-Dgtk_doc=false} \
    %{?_disable_dbus:-Ddbus=false} \
    %{?_disable_xps:-Dxps=disabled} \
    %{?_enable_ps:-Dps=enabled} \
    %{?_disable_introspection:-Dintrospection=false} \
    %{?_enable_browser_plugin:-Dbrowser_plugin=true \
    -Dbrowser_plugin_dir='%browser_plugins_path'} \
    %{?_enable_multimedia:-Dmultimedia=enabled} \
    %{?_disable_nautilus:-Dnautilus=false}
%nil
%meson_build

%install
%meson_install
%find_lang %name --with-gnome

%files
%_bindir/evince*
%{?_enable_dbus:
%_libexecdir/evince*
%_prefix/lib/systemd/user/%xdg_name.service}
%{?_enable_nautilus:%_libdir/nautilus/extensions-3.0/libevince-properties-page.so}
%dir %_libdir/evince
%dir %_libdir/evince/%so_ver
%dir %_libdir/evince/%so_ver/backends
%_libdir/evince/%so_ver/backends/libcomicsdocument.so
%_libdir/evince/%so_ver/backends/libdjvudocument.so
%_libdir/evince/%so_ver/backends/libpdfdocument.so
%{?_enable_ps:%_libdir/evince/%so_ver/backends/libpsdocument.so}
%_libdir/evince/%so_ver/backends/libtiffdocument.so
%{?_enable_xps:%_libdir/evince/%so_ver/backends/libxpsdocument.so}
%_libdir/evince/%so_ver/backends/*.evince-backend
%exclude %_libdir/evince/%so_ver/backends/dvidocument.evince-backend
%doc AUTHORS NEWS* README.md

%files data -f %name.lang
%{?_enable_dbus:%_datadir/dbus-1/services/org.gnome.evince.Daemon.service}
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_desktopdir/%xdg_name-previewer.desktop
%_datadir/metainfo/%name-comicsdocument.metainfo.xml
%_datadir/metainfo/%name-djvudocument.metainfo.xml
%_datadir/metainfo/%name-pdfdocument.metainfo.xml
%{?_enable_ps:%_datadir/metainfo/%name-psdocument.metainfo.xml}
%_datadir/metainfo/%name-tiffdocument.metainfo.xml
%_datadir/metainfo/%name-xpsdocument.metainfo.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%_datadir/GConf/gsettings/evince.convert
%_datadir/glib-2.0/schemas/org.gnome.Evince.gschema.xml
%_datadir/thumbnailers/evince.thumbnailer
%_iconsdir/hicolor/*/apps/*
%_man1dir/*.1*

%files -n lib%name
%_libdir/libevdocument%{api_ver_major}.so.%{so_ver}*
%_libdir/libevview%{api_ver_major}.so.*

%files dvi
%_libdir/evince/%so_ver/backends/dvidocument.evince-backend
%_libdir/evince/%so_ver/backends/libdvidocument.so
%_datadir/metainfo/%name-dvidocument.metainfo.xml

%files -n lib%name-devel
%_includedir/evince
%_libdir/libevdocument%{api_ver_major}.so
%_libdir/libevview%{api_ver_major}.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/%name
%_datadir/gtk-doc/html/libev*
%endif

%if_enabled introspection
%files -n lib%name-gir
%_libdir/girepository-1.0/EvinceDocument-%api_ver.typelib
%_libdir/girepository-1.0/EvinceView-%api_ver.typelib

%files -n lib%name-gir-devel
%_datadir/gir-1.0/EvinceDocument-%api_ver.gir
%_datadir/gir-1.0/EvinceView-%api_ver.gir
%endif

%if_enabled browser_plugin
%files -n mozilla-plugin-%name
%browser_plugins_path/libevbrowserplugin.so
%endif


%changelog
