Summary: The EXTLINUX bootloader, for booting the local system.
Name: extlinux
Version: 6.04.pre3
Release: alt3
License: GPL-2.0-or-later
Group: System/Base
Url: http://www.syslinux.org/wiki/index.php/The_Syslinux_Project
Packager: Alexey Gladkov <legion@altlinux.ru>

Source0: %name-%version.tar
Source1: configs.tar
Source2: extlinux.sysconfig
Source3: extlinux-config
Source4: extlinux.filetrigger

Patch0: 0016-strip-gnu-property.patch
Patch1: 0017-single-load-segment.patch
Patch2: 0018-prevent-pow-optimization.patch
Patch3: 0019-GCC-10-compatibility.patch

BuildRequires: libe2fs-devel
BuildRequires: libuuid-devel
BuildRequires: nasm
BuildRequires: python3-base

Requires: libshell util-linux

Conflicts: syslinux-extlinux
Obsoletes: syslinux4-extlinux
Provides: syslinux4-extlinux = %version-%release

ExclusiveArch: %{ix86} x86_64

%global _unpackaged_files_terminate_build 1
%add_verify_elf_skiplist /boot/extlinux/*
%add_findreq_skiplist /boot/extlinux/*

%description
The EXTLINUX bootloader, for booting the local system, as well as all
the SYSLINUX/PXELINUX modules in /boot.

%package doc
Summary: Extlinux documentation.
Group: Documentation

%description doc
Extlinux documentation.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
rm -rf mk/devel.mk

sed -i \
	-e 's,\(strip tidy clean dist install installer netinstall\):$,\1 extbootinstall:,' \
	Makefile

make bios \
	PYTHON=python3

%install
make bios extbootinstall \
	INSTALLROOT="%buildroot" \
	EXTLINUXDIR=/boot/extlinux

mkdir -p -- %buildroot/%_sysconfdir/sysconfig \
            %buildroot/%_rpmlibdir \
            %buildroot/%_man1dir \
            %buildroot/sbin

cp -a         bios/mbr/*mbr.bin      %buildroot/boot/extlinux/
install -m755 bios/extlinux/extlinux %buildroot/sbin/

install -m644 man/extlinux.1 %buildroot/%_man1dir/
install -m644 %SOURCE2       %buildroot/%_sysconfdir/sysconfig/extlinux
install -m755 %SOURCE3       %buildroot/sbin/
install -m755 %SOURCE4       %buildroot/%_rpmlibdir/

tar -C %buildroot/boot/extlinux -xf %SOURCE1

cd %buildroot/boot
ln -s . boot

cd %buildroot/%_sysconfdir
ln -s ../boot/extlinux/extlinux.conf   .
ln -s ../boot/extlinux/extlinux.conf.d .

%pre
[ ! -L /sbin/extlinux-config ] || rm -f -- /sbin/extlinux-config

%files
%dir /boot/extlinux/extlinux.conf.d
%config(noreplace) /boot/extlinux/extlinux.conf
%config(noreplace) /boot/extlinux/extlinux.conf.d/.*.conf
%config(noreplace) /boot/extlinux/extlinux.conf.d/*.conf
%config(noreplace) %_sysconfdir/sysconfig/extlinux
%_sysconfdir/extlinux.conf
%_sysconfdir/extlinux.conf.d
/boot/boot
/boot/extlinux/memdisk
/boot/extlinux/*.bin
/boot/extlinux/*.c32
/sbin/extlinux
/sbin/extlinux-config
%_rpmlibdir/*
%_man1dir/extlinux.1*

%files doc
%doc COPYING NEWS doc/*
%doc sample

%changelog
