# BEGIN SourceDeps(oneline):
BuildRequires: /proc
# END SourceDeps(oneline)
%define beta beta3

Name: fakenes
Version: 0.5.9
Release: alt2.5.%beta
Summary: Nintendo Entertainment System emulator
Group: Emulators
License: Artistic
Url: http://fakenes.sourceforge.net/
Source0: http://downloads.sourceforge.net/%name/%name-%version-%beta.tar.gz
Source1: %name.desktop
Patch0: fakenes-0.5.8-menu-exit.patch
Patch1: fakenes-0.5.8-driver-switch.patch
Patch2: fakenes-0.5.9-beta3-gcc43.patch
Patch3: fakenes-0.5.9-beta3-openal-build.patch
Patch4: fakenes-0.5.9-beta3-allegro44-build.patch
Patch5: fakenes-0.5.9-beta3-libm-build.patch
BuildRequires: liballegro-devel zlib-devel libopenal-devel
BuildRequires: libGLU-devel libalut-devel desktop-file-utils
BuildRequires: libicns-utils libicns-devel gcc gcc-c++
Requires: icon-theme-hicolor

%description
FakeNES is an Open Source NES emulator.  It uses the excellent Allegro
multimedia library for input, graphics, and sound effects/music across
various platforms.  It is written in 100%% C, and was originally designed to
run on DOS and Microsoft Windows, but now features a POSIX build system as
well.  There are also official builds available for Mac OS X.

%prep
%setup -n %name-%version-%beta
%patch0 -p1 -z .menu
%patch1 -p1 -z .driver
%patch2 -p1 -z .gcc43
%patch3 -p1 -z .openal-build
%patch4 -p1 -z .allegro44-build
%patch5 -p1 -z .libm
sed -i 's/\r//' docs/faq.html

%build
%add_optflags -fcommon -DALLEGRO_NO_FIX_ALIASES
export CFLAGS="$RPM_OPT_FLAGS -ffast-math"
make cbuild
./cbuild --verbose
icns2png -x build/mac/FakeNES.icns
touch -r build/mac/FakeNES.icns FakeNES_128x128x32.png

%install
install -D -m 755 %name $RPM_BUILD_ROOT%_bindir/%name
# below is the desktop file and icon stuff.
mkdir -p $RPM_BUILD_ROOT%_datadir/applications
desktop-file-install            \
  --dir $RPM_BUILD_ROOT%_datadir/applications \
  %SOURCE1
mkdir -p $RPM_BUILD_ROOT%_datadir/icons/hicolor/128x128/apps
install -p -m 644 FakeNES_128x128x32.png \
  $RPM_BUILD_ROOT%_datadir/icons/hicolor/128x128/apps/%name.png


%files
%doc docs/CHANGES docs/LICENSE docs/README docs/faq.html
%_bindir/%name
%_datadir/applications/%name.desktop
%_datadir/icons/hicolor/128x128/apps/%name.png

%changelog
