%define _unpackaged_files_terminate_build 1
%ifarch %arm
%def_disable check
%else
%def_enable check
%endif

Name: fish
Version: 3.7.0
Release: alt1

Summary: A friendly interactive shell
License: GPLv2+
Group: Shells

URL: http://fishshell.com/

# https://github.com/fish-shell/fish-shell.git
Source: %name-%version.tar

Requires: man
BuildRequires(pre): rpm-build-python3 rpm-macros-cmake
BuildRequires: libncurses-devel gcc-c++
BuildRequires: libpcre2-devel >= 10.22
BuildRequires: cmake
BuildRequires: python3-module-sphinx-sphinx-build-symlink
# for check
BuildRequires: ctest
BuildRequires: /proc /dev/pts
BuildRequires: procps
BuildRequires: python3-module-pexpect
BuildRequires: git-core

%description
fish is a shell geared towards interactive use. Its features are
focused on user friendliness and discoverability. The language syntax
is simple but incompatible with other shell languages.

%prep
%setup
echo "%version" > version

rm -vrf pcre2

# Change the bundled scripts to invoke the python binary directly.
for f in $(find share/tools -type f -name '*.py'); do
    sed -i -e '1{s@^#!.*@#!%{__python3}@}' "$f"
done

%ifarch %e2k
sed -i 's/(\*handle_flag_q)>/(handle_flag_q)*>/' src/builtins/path.cpp
%endif

%build
%cmake -DCMAKE_INSTALL_SYSCONFDIR=%_sysconfdir
%cmake_build

%install
%cmakeinstall_std
%find_lang %name

rm -f %buildroot%_datadir/fish/completions/docker.fish
rm -rf %buildroot%_datadir/pkgconfig

%check
export SHOW_INTERACTIVE_LOG=1
%cmake_build --target test

%post
grep -q %_bindir/fish %_sysconfdir/shells ||
	echo %_bindir/fish >>%_sysconfdir/shells

%postun
. shell-quote
if [ "$1" = 0 ]; then
	sed -i "/^$(quote_sed_regexp %_bindir/fish)$/ d" %_sysconfdir/shells
fi

%files -f %name.lang
%_bindir/*
%dir %_sysconfdir/fish
%config %_sysconfdir/fish/config.fish
%_datadir/fish
%doc %_docdir/%name
%_man1dir/*
%_desktopdir/fish.desktop
%_pixmapsdir/fish.png

%changelog
