%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

# 1.9.3: test suite fails on ppc64le
%ifarch ppc64le
%def_without check
%endif

%def_with check

%def_enable tests
%def_enable flashrom

# fwupdate is only available on these arches
%ifarch x86_64 aarch64
%def_enable uefi
%def_enable gpio
%endif

%ifarch x86_64 %ix86
%def_enable msr
%endif

%define fwupd_pluginsdir %_libdir/fwupd-%version

Name: fwupd
Version: 1.9.20
Release: alt1.p10.1

Summary: Firmware update daemon
License: LGPL-2.1+
Group: System/Configuration/Hardware
Url: https://github.com/fwupd/fwupd

Source0: %name-%version.tar
Source2: fwupd.watch
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-ubt

BuildRequires: bash-completion
BuildRequires: cmake
BuildRequires: git-core
BuildRequires: gi-docgen
BuildRequires: libappstream-glib-devel
BuildRequires: libmm-glib-devel
BuildRequires: libqmi-glib-devel
BuildRequires: libmbim-glib-devel
BuildRequires: libprotobuf-c-devel
BuildRequires: /usr/bin/protoc /usr/bin/protoc-gen-c
BuildRequires: libarchive-devel
BuildRequires: libcolord-devel
BuildRequires: liblzma-devel
BuildRequires: libcbor-devel
BuildRequires: libcurl-devel
BuildRequires: libelf-devel
BuildRequires: libgnutls-devel
BuildRequires: libgpgme-devel
BuildRequires: libgudev-devel
BuildRequires: libgusb-gir-devel
BuildRequires: libjcat-devel >= 0.1.10
BuildRequires: libpango-devel
BuildRequires: libpolkit-devel
%if_enabled flashrom
BUildRequires: libflashrom-devel
%endif
BuildRequires: libdrm-devel
BuildRequires: libsoup-devel
BuildRequires: libsqlite3-devel
BuildRequires: libsystemd-devel
BuildRequires: libtpm2-tss-devel
BuildRequires: libudev-devel
BuildRequires: libumockdev-devel
BuildRequires: libuuid-devel
BuildRequires: libxmlb-devel
BuildRequires: meson
BuildRequires: python3-module-Pillow
BuildRequires: python3-module-pycairo
BuildRequires: python3-module-pygobject3
BuildRequires: typelib(Gtk)
BuildRequires: typelib(GdkX11)
BuildRequires: python3-module-jinja2
BuildRequires: vala-tools
BuildRequires: gobject-introspection-devel
BuildRequires: /proc

# Build with passim starting from p11
# No passim in p10 due to old libsoup3.0 and glib2
%if "%(rpmvercmp '%ubt_id' 'M110')" >= "0"
BuildRequires: libpassim-devel
%endif

%if_enabled uefi
BuildRequires: libpango-devel
BuildRequires: libcairo-devel libcairo-gobject-devel
BuildRequires: libfreetype-devel
BuildRequires: fontconfig
BuildRequires: fonts-ttf-dejavu
BuildRequires: gnu-efi
Requires: fwupd-efi
Provides: fwupdate
Obsoletes: fwupdate
%endif

%if_with check
BuildRequires: rpm-build-vm /dev/kvm
%endif

Requires: bubblewrap
Requires: libgusb >= 0.3.5

Obsoletes: fwupd-labels <= %EVR

%description
fwupd is a daemon to allow session software to update device firmware.

%package devel
Summary: Development package for %name
Group: Development/C
Requires: %name = %EVR

%description devel
Files for development with %name.

%package tests
Group: System/Configuration/Hardware
Summary: Data files for installed tests

%description tests
Data files for installed tests.

%package plugin-modem-manager
Group: System/Configuration/Hardware
Summary: fwupd plugin using ModemManger
Requires: %name = %EVR

%description plugin-modem-manager
This provides the optional package which is only required on hardware that
might have mobile broadband hardware. It is probably not required on servers.

%prep
%setup
%patch0 -p1

# 1.8.8: 'lenovo-thinklmi-self-test' fails on aarch64 with:
# "Failed to load SMBIOS: neither SMBIOS or DT found"
# due to missing /sys/class/dmi/id in qemu-system-aarch64
%ifarch aarch64
sed -i -e "/get_option('tests')/ s/$/ and false/" \
    plugins/lenovo-thinklmi/meson.build
%endif

%build
%meson \
    -Ddocs=enabled \
    --debug \
    -Dfirmware-packager=true \
    -Dman=true \
    -Dlvfs=true \
    -Dsupported_build=enabled \
    -Dlaunchd=disabled \
%if_enabled flashrom
    -Dplugin_flashrom=enabled \
%else
    -Dplugin_flashrom=disabled \
%endif
%if_enabled msr
    -Dplugin_msr=enabled \
%else
    -Dplugin_msr=disabled \
%endif
%if_enabled tests
    -Dtests=true \
%else
    -Dtests=false \
%endif
%if_enabled gpio
    -Dplugin_gpio=enabled \
%else
    -Dplugin_gpio=disabled \
%endif
%if_enabled uefi
    -Dplugin_uefi_capsule=enabled \
    -Dplugin_uefi_pk=enabled \
    -Dplugin_tpm=enabled \
    -Defi_binary=false \
%else
    -Dplugin_redfish=enabled \
    -Dplugin_uefi_capsule=disabled \
    -Dplugin_uefi_pk=disabled \
    -Dplugin_nvme=enabled \
%endif
    -Dplugin_modem_manager=enabled \
#

%__meson_build

%install
%__meson_install

# CET is available only since i686
%ifarch i386 i486 i586
rm -f %buildroot%_libexecdir/fwupd/fwupd-detect-cet ||:
%endif

mkdir -p --mode=0700 %buildroot%_localstatedir/fwupd/gnupg
mv %buildroot%_docdir/fwupd %buildroot%_docdir/fwupd-devel-%version
rm -f %buildroot%_docdir/%name-devel-%version/lib*
mv %buildroot%_docdir/libfw* %buildroot%_docdir/fwupd-devel-%version/

%find_lang %name

%check
vm-run --sbin --udevd --kvm=cond --overlay=tmpfs:/usr/src \
       %__meson_test

%files -f %name.lang
%doc README.md COPYING
%_man1dir/fwupdtool.1*
%_man1dir/fwupdmgr.1*
%_man1dir/dbxtool.1*
%_man5dir/*
%_man8dir/*
%config(noreplace)%_sysconfdir/fwupd/fwupd.conf
%dir %_libexecdir/fwupd
%_libexecdir/fwupd/fwupd
%_bindir/fwupdtool
%_libexecdir/fwupd/fwupdoffline
%ifarch x86_64
%_libexecdir/fwupd/fwupd-detect-cet
%endif
%_datadir/bash-completion/completions/*
%_datadir/fish/vendor_completions.d/fwupdmgr.fish
%_iconsdir/hicolor/scalable/apps/org.freedesktop.fwupd.svg
%_bindir/dbxtool
%_bindir/fwupdmgr
%dir %_sysconfdir/fwupd
%dir %_sysconfdir/fwupd/remotes.d
%_sysconfdir/fwupd/bios-settings.d
%config(noreplace)%_sysconfdir/fwupd/remotes.d/*.conf
%_sysconfdir/pki/fwupd
%_sysconfdir/pki/fwupd-metadata
%dir %_datadir/fwupd
%dir %_datadir/fwupd/metainfo
%dir %_datadir/fwupd/remotes.d
%dir %_datadir/fwupd/remotes.d/vendor
%_datadir/dbus-1/system.d/org.freedesktop.fwupd.conf
%_datadir/fwupd/remotes.d/vendor/firmware
%_datadir/dbus-1/interfaces/org.freedesktop.fwupd.xml
%_datadir/polkit-1/actions/org.freedesktop.fwupd.policy
%_datadir/polkit-1/rules.d/org.freedesktop.fwupd.rules
%_datadir/dbus-1/system-services/org.freedesktop.fwupd.service
%_datadir/metainfo/org.freedesktop.fwupd.metainfo.xml
%_datadir/fwupd/metainfo/org.freedesktop.fwupd.remotes.lvfs-testing.metainfo.xml
%_datadir/fwupd/metainfo/org.freedesktop.fwupd.remotes.lvfs.metainfo.xml
%_datadir/fwupd/firmware_packager.py
%_datadir/fwupd/add_capsule_header.py
%_datadir/fwupd/install_dell_bios_exe.py
%_datadir/fwupd/simple_client.py
%_unitdir/fwupd-offline-update.service
%_unitdir/fwupd.service
%_unitdir/fwupd-refresh.timer
%_unitdir/fwupd-refresh.service
%_unitdir/system-update.target.wants/
/lib/systemd/system-shutdown/fwupd.shutdown
%dir %_localstatedir/fwupd
%dir %_datadir/fwupd/quirks.d
%_datadir/fwupd/quirks.d/builtin.quirk.gz
%_libdir/libfwupd*.so.*
%_libdir/girepository-1.0/Fwupd-2.0.typelib
/lib/udev/rules.d/*.rules
%dir %fwupd_pluginsdir
%fwupd_pluginsdir/libfwupd*.so
%if_enabled flashrom
%fwupd_pluginsdir/libfu_plugin_flashrom.so
%endif
%if_enabled msr
%_modulesloaddir/fwupd-msr.conf
%endif
%if_enabled uefi
%config(noreplace)%_sysconfdir/grub.d/35_fwupd
%_datadir/fwupd/uefi-capsule-ux.tar.xz
%endif
/lib/sysusers.d/fwupd.conf

%ghost %_localstatedir/fwupd/gnupg

%files plugin-modem-manager
%fwupd_pluginsdir/libfu_plugin_modem_manager.so

%files devel
%_datadir/gir-1.0/Fwupd-2.0.gir
%_docdir/fwupd-devel-%version
%_includedir/fwupd-1
%_libdir/libfwupd*.so
%_libdir/pkgconfig/fwupd.pc
%_datadir/vala/vapi/*

%files tests
%if_enabled tests
%_datadir/fwupd/host-emulate.d/*.json.gz
%dir %_datadir/installed-tests/fwupd
%dir %_datadir/installed-tests/fwupd/tests
%if_enabled uefi
%_datadir/installed-tests/fwupd/efi
%endif
%_datadir/installed-tests/fwupd/tests/*
%_datadir/installed-tests/fwupd/fwupd-tests.xml
%_datadir/installed-tests/fwupd/*.test
%_datadir/installed-tests/fwupd/*.zip
%_datadir/installed-tests/fwupd/*.cab
%_datadir/installed-tests/fwupd/fakedevice124.jcat
%_datadir/installed-tests/fwupd/fakedevice124.bin
%_datadir/installed-tests/fwupd/fakedevice124.metainfo.xml
%_datadir/installed-tests/fwupd/*.sh
%_datadir/installed-tests/fwupd/chassis_type
%_datadir/installed-tests/fwupd/sys_vendor
%_datadir/fwupd/device-tests/*.json
%_libexecdir/installed-tests/fwupd
%dir %_sysconfdir/fwupd/remotes.d
%_datadir/fwupd/remotes.d/fwupd-tests.conf
%endif

%changelog
