%define        gemname cairo

Name:          gem-cairo
Version:       1.17.8
Release:       alt1.2.1
Summary:       ruby bindings for cairo
License:       Ruby or GPL-2.0-or-later
Group:         Development/Ruby
Url:           https://rcairo.github.io/
Vcs:           https://github.com/rcairo/rcairo.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libcairo-devel
BuildRequires: glib2-devel
BuildRequires: libpixman-devel
BuildRequires: xorg-glproto-devel
BuildRequires: xorg-dri2proto-devel
BuildRequires: libXau-devel
BuildRequires: libXdmcp-devel
BuildRequires: libXext-devel
BuildRequires: libXdamage-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libpcre-devel
BuildRequires: libuuid-devel
BuildRequires: libffi-devel
BuildRequires: bzlib-devel
BuildRequires: libossp-uuid-dce-devel
BuildRequires: libdrm-devel
BuildRequires: libbrotli-devel
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(xshmfence)
BuildRequires: pkgconfig(libpcre2-8)
BuildRequires: gem(native-package-installer) >= 1.0.3
BuildRequires: gem(pkg-config) >= 1.2.2
%if_with check
BuildRequires: gem(red-colors) >= 0
BuildRequires: gem(bundler) >= 0
BuildRequires: gem(test-unit) >= 0
BuildRequires: gem(packnga) >= 0
BuildRequires: gem(poppler) >= 3.1.1
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Requires:      gem(native-package-installer) >= 1.0.3
Requires:      gem(pkg-config) >= 1.2.2
Requires:      gem(red-colors) >= 0
Obsoletes:     ruby-rcairo < 1.7.0
Provides:      ruby-rcairo = 1.17.8
Provides:      gem(cairo) = 1.17.8


%description
Ruby bindings for cairo // cairo extension for Ruby.


%package       -n gem-cairo-doc
Version:       1.17.8
Release:       alt1.2.1
Summary:       ruby bindings for cairo documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета cairo
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(cairo) = 1.17.8

%description   -n gem-cairo-doc
ruby bindings for cairo documentation files.

Ruby bindings for cairo // cairo extension for Ruby.

%description   -n gem-cairo-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета cairo.


%package       -n gem-cairo-devel
Version:       1.17.8
Release:       alt1.2.1
Summary:       ruby bindings for cairo development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета cairo
Group:         Development/Ruby
BuildArch:     noarch
Autoreq:       yes,noruby

Requires:      gem(cairo) = 1.17.8
Requires:      gem(bundler) >= 0
Requires:      gem(test-unit) >= 0
Requires:      gem(packnga) >= 0
Requires:      libcairo-devel
Requires:      glib2-devel
Requires:      libpixman-devel
Requires:      xorg-glproto-devel
Requires:      xorg-dri2proto-devel
Requires:      libXau-devel
Requires:      libXdmcp-devel
Requires:      libXext-devel
Requires:      libXdamage-devel
Requires:      libXxf86vm-devel
Requires:      libpcre-devel
Requires:      libuuid-devel
Requires:      libffi-devel
Requires:      bzlib-devel
Requires:      libossp-uuid-dce-devel
Requires:      libdrm-devel
Requires:      pkgconfig(expat)
Requires:      pkgconfig(harfbuzz)
Requires:      pkgconfig(xshmfence)
Requires:      pkgconfig(libpcre2-8)
Obsoletes:     rcairo-devel < 1.7.0
Provides:      rcairo-devel = 1.17.8


%description   -n gem-cairo-devel
ruby bindings for cairo development package.

Ruby bindings for cairo // cairo extension for Ruby.

%description   -n gem-cairo-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета cairo.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.rdoc
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n gem-cairo-doc
%doc README.rdoc
%ruby_gemdocdir

%files         -n gem-cairo-devel
%doc README.rdoc
%ruby_gemincludedir/*


%changelog
