%define        gemname eventmachine

Name:          gem-eventmachine
Version:       1.3.0.dev.1
Release:       alt1
Summary:       Fast, simple event-processing library for Ruby programs
License:       Ruby or GPL-2.0
Group:         Development/Ruby
Url:           http://www.rubyeventmachine.com/
Vcs:           https://github.com/eventmachine/eventmachine.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gcc-c++
BuildRequires: net-tools
BuildRequires: /proc
BuildRequires: libssl-devel
BuildRequires: gem(test-unit) >= 3.2 gem(test-unit) < 4
BuildRequires: gem(rake-compiler) >= 1.1 gem(rake-compiler) < 2
BuildRequires: gem(rake-compiler-dock) >= 0.6.3 gem(rake-compiler-dock) < 2

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency rake-compiler-dock >= 0.7.2,rake-compiler-dock < 2
Obsoletes:     ruby-eventmachine < %EVR
Provides:      ruby-eventmachine = %EVR
Provides:      gem(eventmachine) = 1.3.0.dev.1


%description
EventMachine implements a fast, single-threaded engine for arbitrary network
communications. It's extremely easy to use in Ruby. EventMachine wraps all
interactions with IP sockets, allowing programs to concentrate on the
implementation of network protocols. It can be used to create both network
servers and clients. To create a server or client, a Ruby program only needs to
specify the IP address and port, and provide a Module that implements the
communications protocol. Implementations of several standard network protocols
are provided with the package, primarily to serve as examples. The real goal of
EventMachine is to enable programs to easily interface with other programs using
TCP/IP, especially if custom protocols are required.


%package       -n gem-eventmachine-doc
Version:       1.3.0.dev.1
Release:       alt1
Summary:       Fast, simple event-processing library for Ruby programs documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета eventmachine
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(eventmachine) = 1.3.0.dev.1

%description   -n gem-eventmachine-doc
Fast, simple event-processing library for Ruby programs documentation
files.

EventMachine implements a fast, single-threaded engine for arbitrary network
communications. It's extremely easy to use in Ruby. EventMachine wraps all
interactions with IP sockets, allowing programs to concentrate on the
implementation of network protocols. It can be used to create both network
servers and clients. To create a server or client, a Ruby program only needs to
specify the IP address and port, and provide a Module that implements the
communications protocol. Implementations of several standard network protocols
are provided with the package, primarily to serve as examples. The real goal of
EventMachine is to enable programs to easily interface with other programs using
TCP/IP, especially if custom protocols are required.

%description   -n gem-eventmachine-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета eventmachine.


%package       -n gem-eventmachine-devel
Version:       1.3.0.dev.1
Release:       alt1
Summary:       Fast, simple event-processing library for Ruby programs development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета eventmachine
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(eventmachine) = 1.3.0.dev.1
Requires:      gem(test-unit) >= 3.2 gem(test-unit) < 4
Requires:      gem(rake-compiler) >= 1.1 gem(rake-compiler) < 2
Requires:      gem(rake-compiler-dock) >= 0.6.3 gem(rake-compiler-dock) < 2
Requires:      gcc-c++
Requires:      net-tools
Requires:      /proc
Requires:      libssl-devel

%description   -n gem-eventmachine-devel
Fast, simple event-processing library for Ruby programs development
package.

EventMachine implements a fast, single-threaded engine for arbitrary network
communications. It's extremely easy to use in Ruby. EventMachine wraps all
interactions with IP sockets, allowing programs to concentrate on the
implementation of network protocols. It can be used to create both network
servers and clients. To create a server or client, a Ruby program only needs to
specify the IP address and port, and provide a Module that implements the
communications protocol. Implementations of several standard network protocols
are provided with the package, primarily to serve as examples. The real goal of
EventMachine is to enable programs to easily interface with other programs using
TCP/IP, especially if custom protocols are required.

%description   -n gem-eventmachine-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета eventmachine.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n gem-eventmachine-doc
%doc README.md
%ruby_gemdocdir

%files         -n gem-eventmachine-devel
%doc README.md
%ruby_includedir/*


%changelog
