%define _unpackaged_files_terminate_build 1

%set_verify_elf_method strict,lint=relaxed

Name: gif2png
Version: 3.0.0
Release: alt4.git.a9592ae
Summary: A GIF to PNG converter
Group: Graphics
License: BSD-2-Clause
Url: http://catb.org/~esr/gif2png/

# https://gitlab.com/esr/gif2png
Source: %name-%version.tar
Patch1: gif2png-2.5.8-alt-web2png.patch

ExclusiveArch: %go_arches

BuildRequires(pre): rpm-build-golang rpm-build-python
BuildRequires: python-modules xmlto

%description
The gif2png program converts files from the obsolescent Graphic
Interchange Format to Portable Network Graphics.  The conversion
preserves all graphic information, including transparency, perfectly.
The gif2png program can even recover data from corrupted GIFs.

There exists a 'web2png' program in a separate package which is able
to convert entire directory hierarchies.

%package -n web2png
Summary: A GIF to PNG converter for entire directory hierarchies
Group: Graphics
Requires: %name = %EVR
BuildArch: noarch

%description -n web2png
The gif2png program converts files from the obsolescent Graphic
Interchange Format to Portable Network Graphics.  The conversion
preserves all graphic information, including transparency, perfectly.
The gif2png program can even recover data from corrupted GIFs.

The distribution also includes a Python script, web2png, that will
convert entire web hierarchies (images and HTML or PHP pages).

%prep
%setup
%patch1 -p1

mkdir -p src/golang.org/x
cp -r %go_root/src/cmd/vendor/golang.org/x/sys src/golang.org/x/
cp -r %go_root/src/cmd/vendor/golang.org/x/crypto src/golang.org/x/

%build
export GO111MODULE=off
export GOPATH="$(pwd):%go_path"
export CFLAGS="$RPM_OPT_FLAGS $(getconf LFS_CFLAGS)"

%make_build

%install
%makeinstall_std

%check
%make_build -k -C test

%files
%doc NEWS README
%_bindir/gif2png
%_man1dir/gif2png.1*

%files -n web2png
%_bindir/web2png
%_man1dir/web2png.1*

%changelog
