Epoch: 1
Packager: Vitaly Lipatov <lav@altlinux.ru>
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dvipdfm /usr/bin/makeindex gcc-c++ texlive-latex-base texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           gnucap
Version:        0.35
Release:        alt124
Summary:        The Gnu Circuit Analysis Package
Group:          Engineering
License:        GPLv2+
URL:            http://www.gnu.org/software/gnucap/
Source0:        http://www.gnucap.org/devel/gnucap-%{version}.tar.gz
Patch0:         gnucap-0.34-debian.patch
Patch1:         gnucap-0.35-gcc43.patch
Patch2:         gnucap-0.35-gcc6.patch
BuildRequires:  readline-devel
Source44: import.info

%ifnarch %e2k
BuildRequires: /usr/bin/hacha /usr/bin/hevea
%endif

%description
The primary component is a general purpose circuit simulator. It performs
nonlinear dc and transient analyses, fourier analysis, and ac analysis. Spice
compatible models for the MOSFET (level 1-7), BJT, and diode are included in
this release. Gnucap is not based on Spice, but some of the models have been
derived from the Berkeley models. Unlike Spice, the engine is designed to do
true mixed-mode simulation. Most of the code is in place for future support of
event driven analog simulation, and true multi-rate simulation.


%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
# use ncurses instead of termcap (bz 226771)
sed -i 's/-ltermcap/-lncurses/g' configure


%build
%configure
%make_build


%install
%makeinstall_std

# for %%doc
rm -r $RPM_BUILD_ROOT%{_datadir}/%{name}
mv doc/acs-tutorial doc/gnucap-tutorial
rm examples/Makefile*


%files
%doc doc/history doc/relnotes.* doc/gnucap-tutorial doc/whatisit
%doc man/gnucap-man.pdf examples
%doc doc/COPYING
%{_bindir}/%{name}*
%{_mandir}/man1/%{name}.1*


%changelog
