%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define Name GParted

%def_with pic
%def_disable usermode
%def_enable xhost_root
%def_disable check

Name: gparted
Version: 1.4.0
Release: alt1

Summary: %Name Partition Editor
Summary(ru_RU.UTF-8): Редактор разделов %Name
Summary(uk_UA.UTF-8): Редактор розділів %Name
Group: System/Configuration/Hardware
License: %gpl2plus
Url: http://%name.sourceforge.net/

%if_disabled snapshot
Source: http://prdownloads.sourceforge.net/%name/%name-%version.tar.gz
%else
Vcs: https://gitlab.gnome.org/GNOME/gparted.git
Source: %name-%version.tar
%endif
Source1: %name-pam
Source2: %name-security

AutoReq: yes, noshell

%define polkit_ver 0.112

Requires: yelp
Requires: polkit >= %polkit_ver
%{?_enable_usermode:Requires: consolehelper}
Requires: hdparm
Requires: dosfstools >= 3.0.18 ntfs-3g btrfs-progs >= 4.1
Requires: cryptsetup
# for raid support
Requires: mdadm dmraid dmsetup lvm2
# for UDF filesystems support
Requires: udftools >= 2.0
# since 1.2.0 (optional)
# exfatprogs conflicts with exfat-utils
Requires: exfatprogs >= 1.1.0

BuildRequires(pre): rpm-build-licenses
BuildRequires: libparted-devel >= 3.2
BuildRequires: libglibmm-devel >= 2.32 libgtkmm3-devel >= 3.4.0
BuildRequires: gcc-c++ libprogsreiserfs-devel libuuid-devel
BuildRequires: intltool yelp-tools
BuildRequires: polkit >= %polkit_ver
%{?_enable_check:BuildRequires: xvfb-run}

%description
%Name stands for %Name Partition Editor. It uses libparted to detect
and manipulate devices and partitiontables while several (optional)
filesystemtools provide support for filesystems not included in
libparted. These optional packages will be detected at runtime and
don't require a rebuild of %Name.
%Name is written in C++ and uses gtkmm as Graphical Toolkit. The
general approach is to keep the GUI as simple as possible.

%description -l ru_RU.UTF-8
%Name - %Name Partition Editor. Он использует libparted для
обнаружения и манипуляций с устройствами и таблицами разделов, а также
некоторые (необязательные) инструменты (не включенные в libparted),
обеспечивающие поддержку файловых систем. Эти необязательные пакеты
обнаруживаются во время выполнения и не требуют пересборки %Name.
%Name написан на C++ с использованием gtkmm в качестве графического
инструментария. Главная задача - оставить GUI максимально простым.

%description -l uk_UA.UTF-8
%Name - %Name Partition Editor. Він використовує libparted для
виявлення та маніпуляцій з пристроями і таблицями разділів, а також
деякі (необов'язкові) інструменти (не включені в libparted), які
забезпечують підтримку файлових систем. Ці необов'язкові пакети
виявляються під час виконання і не потребують перебудови %Name.
%Name написано на C++ з використанням gtkmm в якості графічного
інструментарію. Головне завдання - залишити GUI максимально простим.


%prep
%setup

# get polkit version from pkaction in hasher
subst 's/pkexec --version/pkaction --version/' configure*

%build
#NOCONFIGURE=1 ./autogen.sh
%add_optflags %(getconf LFS_CFLAGS)
%configure %{subst_with pic} \
	%{?_enable_usermode:--bindir=%_sbindir} \
	%{?_enable_xhost_root:--enable-xhost-root} \
	--enable-libparted-dmraid \
	--enable-online-resize
%make_build
bzip2 --best --keep --force ChangeLog

%install
%makeinstall_std
%find_lang --with-gnome %name

%if_enabled usermode
install -pD -m640 %SOURCE1 %buildroot%_sysconfdir/pam.d/%name
install -pD -m640 %SOURCE2 %buildroot%_sysconfdir/security/console.apps/%name
install -d -m 0755 %buildroot%_bindir
ln -s %_bindir/consolehelper %buildroot%_bindir/%name
sed -i 's|%_sbindir|%_bindir|' %buildroot%_desktopdir/%name.desktop
%endif

%check
xvfb-run %make check

%files -f %name.lang
%doc AUTHORS ChangeLog.* README NEWS
%_bindir/%name
%_libexecdir/%{name}bin
%_man8dir/%name.8.*
%_iconsdir/hicolor/*/apps/*
%_desktopdir/%name.desktop
%_datadir/polkit-1/actions/org.gnome.gparted.policy
%_datadir/appdata/%name.appdata.xml

%if_enabled usermode
%_bindir/%name
%_sysconfdir/pam.d/%name
%_sysconfdir/security/console.apps/%name
%endif

%changelog
