%def_disable snapshot
%def_enable check

Name: gpodder
Version: 3.10.21
Release: alt1

Summary: podcast receiver/catcher in PyGTK
License: GPL-3.0-or-later
Group: Sound
Url: http://gpodder.org

%if_disabled snapshot
Source: https://github.com/gpodder/gpodder/archive/%version/%name-%version.tar.gz
%else
Vcs: https://github.com/gpodder/gpodder.git
Source: %name-%version.tar
%endif

BuildArch: noarch

%add_python3_path %_datadir/%name

# should be provided by python3-module-requests
%add_python3_req_skip requests.packages.urllib3.exceptions
%add_python3_req_skip requests.packages.urllib3.util.retry

# M$ and ubuntu specific
%add_python3_req_skip comtypes pywintypes win32gui appindicator
%filter_from_requires /win32ctypes/d
%add_typelib_req_skiplist typelib(Unity)
# Optional dependencies
# https://github.com/SoCo/SoCo
%add_python3_req_skip soco
# https://github.com/freevo/kaa-metadata
# last commit in 2015
%add_python3_req_skip kaa.metadata

%define urllib3_ver 1.26.5
%define mgpoclient_ver 1.8

Requires: typelib(Gtk) = 3.0
Requires: python3-module-mygpoclient >= %mgpoclient_ver
Requires: python3-module-urllib3 >= %urllib3_ver
Requires: %_bindir/ffmpeg xdg-utils
Requires: python3-module-eyeD3

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-devel python3-module-mygpoclient
BuildRequires: python3-module-feedparser help2man intltool desktop-file-utils
%if_enabled check
BuildRequires: %_bindir/py.test3
BuildRequires: python3-module-pytest-cov python3-module-pytest-httpserver
BuildRequires: python3-module-podcastparser python3-modules-sqlite3
BuildRequires: python3-module-minimock python3-module-coverage
BuildRequires: python3-module-requests
%endif

%description
gPodder enables you to subscribe to RSS feeds and download
podcast episodes from these feeds. gPodder can operate in
GUI mode and in CLI mode. Downloaded podcasts can either
be synchronized to portable MP3 players (including iPods)
or played back on the user's desktop.

%prep
%setup
find ./ -name "*.py" -print0 | \
xargs -r0 sed -i -e "s|\(#\!/usr/bin/python\)$|\13|" --

%build
%make

%install
%makeinstall_std

%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Tuner \
	%buildroot%_desktopdir/gpodder.desktop

%check
PYTHON=python3 PYTEST=%_bindir/py.test3 %make unittest

%files -f %name.lang
%_bindir/*
%python3_sitelibdir/*
%_desktopdir/%name.desktop
%_desktopdir/%name-url-handler.desktop
%_datadir/dbus-1/services/org.gpodder.service
%_datadir/%name
%_iconsdir/hicolor/*/apps/%name.svg
%_iconsdir/hicolor/*/apps/%name.png
%_man1dir/*
%_datadir/metainfo/*.appdata.xml


%changelog
