%def_without flexiblas
%def_with openmpi

Name: gretl
Version: 2022c
Release: alt1

Summary: A tool for econometric analysis

License: GPLv3+ and BSD and MIT
Group: Sciences/Mathematics
Url: http://gretl.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: http://downloads.sourceforge.net/%name/%name-%version.tar.xz
Source: %name-%version.tar

BuildRequires: bash-completion

%if_with flexiblas
BuildRequires: flexiblas-devel
%else
BuildRequires: libblas-devel, liblapack-devel
%endif

BuildRequires: libgsf-devel

BuildRequires: desktop-file-utils
BuildRequires: libfftw3-devel
BuildRequires: gcc-c++
BuildRequires: gettext-tools
BuildRequires: glib2-devel
BuildRequires: gmp-devel
BuildRequires: gnuplot
BuildRequires: libgtk+3-devel
BuildRequires: libgtksourceview3-devel
BuildRequires: libjson-glib-devel
BuildRequires: libcurl-devel
BuildRequires: libxml2-devel
BuildRequires: libgnomeui-devel
BuildRequires: libmpfr-devel
BuildRequires: libncurses-devel
%if_with openmpi
BuildRequires: openmpi-devel
%endif
BuildRequires: libreadline-devel
BuildRequires: xdg-utils

Requires: gnuplot

%description
A cross-platform software package for econometric analysis,
written in the C programming language.

%package devel
Group: Development/C
Summary: Development files for %name
Requires: %name = %EVR
Requires: pkg-config

%description devel
This package contains the development files for %name.

%package openmpi
Group: Sciences/Mathematics
Summary: Binary openmpi files for %name
BuildRequires: openmpi-devel
BuildRequires: make
# Require explicitly for dir ownership and to guarantee the pickup of the right runtime
Requires: openmpi
Requires: %name = %EVR

%description openmpi
This package contains the binary openmpi files for %name.

%prep
%setup

CC=mpicc
CXX=mpic++
FC=mpifort

%if_with flexiblas
%__subst 's/-lblas/-lflexiblas/g' -e 's/-llapack/-lflexiblas/g' configure
%endif

%build
# Build OpenMPI version
#_openmpi_load
export LAPACK_LIBS="-llapack"
%if_with openmpi
. %_libdir/openmpi/bin/mpivars.sh
%endif
%configure \
	--disable-static \
	--disable-rpath \
	--disable-avx \
%if_with openmpi
	--with-mpi \
	--with-mpi-lib=%_libdir/openmpi/lib/ \
	--with-mpi-include=%_libdir/openmpi/include/ \
%endif
	--enable-build-editor
# FIXME: --disable-rpath is broken?
sed -ri 's/^(hardcode_libdir_flag_spec|hardcode_libdir_flag_spec_CXX|runpath_var)=.*/\1=/' libtool
export LD_LIBRARY_PATH=$(pwd)/lib/.libs:$LD_LIBRARY_PATH
%make_build

%install
%makeinstall_std
%find_lang %name
rm -rv %buildroot/%_libdir/libgretl*.la
rm -rv %buildroot/%_datadir/%name/doc

%if_with openmpi
#Fix the openmpi binary
mkdir -p %buildroot%_libdir/openmpi/bin
mv %buildroot/%_bindir/gretlmpi %buildroot/%_libdir/openmpi/bin/gretl_openmpi
%endif

desktop-file-install						\
--remove-category="Application;Science;Econometrics" \
--add-category="Education;Science;Math;Economy;"  \
--dir=%buildroot%_desktopdir     \
%buildroot/%_desktopdir/gretl.desktop
#_openmpi_unload
#ldconfig_scriptlets

%files -f %name.lang
%_bindir/gretl
%_bindir/gretlcli
%_bindir/gretl_edit
%_bindir/gretl_x11
%_libdir/gretl-gtk3
%_datadir/%name/
%_man1dir/*
%_libdir/libgretl-1.0.so.*
%_datadir/mime/packages/gretl.xml
%_iconsdir/hicolor/32x32/apps/gretl.png
%_iconsdir/hicolor/32x32/mimetypes/*.png
%_iconsdir/hicolor/48x48/apps/gretl.png
%_iconsdir/hicolor/64x64/apps/gretl.png
%_desktopdir/gretl*
%_datadir/appdata/gretl.appdata.xml

%doc ChangeLog CompatLog README

%files devel
%_pkgconfigdir/gretl.pc
%_libdir/libgretl*.so
%_includedir/%name/

%if_with openmpi
%files openmpi
%_libdir/openmpi/bin/gretl_openmpi
%endif

%changelog
