%define _unpackaged_files_terminate_build 1

Name: gsl
Version: 2.6
Release: alt1
Summary: The GNU Scientific Library for numerical analysis
License: GPL
Group: Development/Other
URL: http://www.gnu.org/software/gsl/gsl.html

# git://git.savannah.gnu.org/gsl.git
Source: %name-%version.tar
Patch1: %name-%version-alt-build.patch

Requires: lib%name = %EVR
Conflicts: lib%name-devel < %EVR

# Automatically added by buildreq on Wed Jun 06 2007
BuildRequires: ghostscript-module-X ghostscript-utils
# explicitly added texinfo for info files
BuildRequires: texinfo
BuildRequires: python-module-sphinx python-module-sphinx_rtd_theme


%package -n lib%name
Summary: Shared librairies for Scientific Library
Group: System/Libraries

%package -n lib%name-devel
Summary: Development environment for Scientific Library
Group: Development/C
Requires: lib%name = %EVR

%package -n lib%name-doc
Summary: book for Scientific Library
Group: Documentation
BuildArch: noarch

%package -n lib%name-info
Summary: Info pages for Scientific Library
Group: Documentation
BuildArch: noarch
Conflicts: %name < %EVR

%package -n lib%name-examples
Summary: Examples sources for using with Scientific Library
Group: Documentation
BuildArch: noarch

%description
The %name package is part of the GNU Scientific Library (GSL). The GSL is a
collection of routines for numerical analysis, written in C.  The GSL is
in alpha development.  It now includes a random number suite, an FFT
package, simulated annealing and root finding.  In the future, it will
include numerical and Monte Carlo integration and special functions.
Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

Install the %name package if you need utilities for high-level scientific
numerical analysis.

%description -n lib%name
The lib%name package is part of the GNU Scientific Library (GSL). The GSL is a
collection of routines for numerical analysis, written in C.  The GSL is
in alpha development.  It now includes a random number suite, an FFT
package, simulated annealing and root finding.  In the future, it will
include numerical and Monte Carlo integration and special functions.
Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

This package contains shared library required for run GSL-based software.

%description -n lib%name-devel
The lib%name-devel package is part of the GNU Scientific Library (GSL). The GSL is a
collection of routines for numerical analysis, written in C.  The GSL is
in alpha development.  It now includes a random number suite, an FFT
package, simulated annealing and root finding.  In the future, it will
include numerical and Monte Carlo integration and special functions.
Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

This package contains shared libs and include headers required for development.

%description -n lib%name-doc
book for developers

%description -n lib%name-info
Info pages for GSL

%description -n lib%name-examples
Sources of examples for using with GSL

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure
%make_build

pushd doc
%make html
popd

%install
%makeinstall

rm -f %buildroot%_libdir/*.a

%files
%_bindir/*
%exclude %_bindir/%name-config
%_man1dir/*
%exclude %_man1dir/%name-config.1*

%files -n lib%name
%doc AUTHORS
%_libdir/*.so.*

%files -n lib%name-devel
%_bindir/%name-config
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*
%_datadir/aclocal/*
%_man1dir/%name-config.1*
%_man3dir/*

%files -n lib%name-doc
%doc ChangeLog NEWS README THANKS TODO DONE VOLUNTEERS NOTES doc/_build/html

%files -n lib%name-info
%_infodir/*.info*

%files -n lib%name-examples
%doc doc/examples

%changelog
