%def_disable snapshot

%define _name gstvalidate
%define ver_major 1.20
%define gst_api_ver 1.0
%define api_ver 1.0

%def_disable doc

Name: gst-devtools
Version: %ver_major.7
Release: alt1

Summary: GStreamer development and validation tools
Group: System/Libraries
License: GPLv2+ and LGPLv2+
Url: http://cgit.freedesktop.org/gstreamer/gst-devtools/

%if_disabled snapshot
Source: http://gstreamer.freedesktop.org/src/%name/%name-%version.tar.xz
%else
Vcs: https://gitlab.freedesktop.org/gstreamer/gst-devtools.git
Source: %name-%version.tar
%endif

%define gst_ver %version

Obsoletes: gst-validate < 1.17.1
Provides: gst-validate = %EVR

Requires: lib%name = %version-%release
Requires: gst-plugins-base%gst_api_ver

%add_python3_path %_libdir/gst-validate-launcher/python

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3
BuildRequires: meson gcc-c++ gst-plugins%gst_api_ver-devel >= %gst_ver gst-plugins-base%gst_api_ver libxml2-devel
BuildRequires: libcairo-devel gobject-introspection-devel gst-plugins%gst_api_ver-gir-devel
BuildRequires: libjson-glib-devel python3-devel
%{?_enable_doc:BuildRequires: hotdoc gstreamer%api_ver-utils}

%description
GStreamer development and validation tools including GstValidate, a
testing framework aiming at providing GStreamer developers tools that
check the GstElements they write behave the way they are supposed to.

%package -n lib%name
Summary: GStreamer Validate library
License: LGPLv2+
Group: System/Libraries
Obsoletes: libgst-validate < 1.17.1
Provides: libgst-validate = %EVR

%description -n lib%name
GStreamer Validate library.

%package -n lib%name-devel
Summary: Development files for %name
License: LGPLv2+
Group: Development/C
Requires: lib%name = %EVR
Obsoletes: libgst-validate-devel < 1.17.1
Provides: libgst-validate-devel = %EVR

%description -n lib%name-devel
This package provides libraries and header files for developing
applications that use Gst Validate library.

%package -n lib%name-devel-doc
Summary: Gst Validate development documentation
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version
Obsoletes: libgst-validate-devel-doc < 1.17.1
Provides: libgst-validate-devel-doc = %EVR

%description -n lib%name-devel-doc
This package contains documentation necessary to develop applications
that use Gst Validate library.

%package -n lib%name-gir
Summary: GObject introspection data for the Gst Validate
Group: System/Libraries
Requires: lib%name = %EVR
Obsoletes: libgst-validate-gir < 1.17.1
Provides: libgst-validate-gir = %EVR

%description -n lib%name-gir
GObject introspection data for the Gst Validate library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Gst Validate
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR
Obsoletes: libgst-validate-gir-devel < 1.17.1
Provides: libgst-validate-gir-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the Gst Validate library.

%prep
%setup

%build
%meson %{?_disable_doc:-Ddoc=disabled}
%meson_build

%install
%meson_install
%find_lang %name

%files
%_bindir/gst-validate-launcher
%_bindir/gst-validate-%api_ver
%_bindir/gst-validate-media-check-%api_ver
%_bindir/gst-validate-images-check-%api_ver
%_libdir/gst-validate-launcher/
%_libdir/gstreamer-%gst_api_ver/lib%{_name}tracer.so
%_datadir/gstreamer-%gst_api_ver/validate/

%files -n lib%name -f %name.lang
%_libdir/lib%_name-%api_ver.so.*
%_libdir/lib%_name-default-overrides-%api_ver.so.*
%dir %_libdir/gstreamer-%gst_api_ver/validate/
%_libdir/gstreamer-%gst_api_ver/validate/*.so
%doc ChangeLog NEWS RELEASE

%files -n lib%name-devel
%_includedir/gstreamer-%gst_api_ver/gst/validate/
%_libdir/lib%_name-%api_ver.so
%_libdir/lib%_name-default-overrides-%api_ver.so
%_pkgconfigdir/gst-validate-%api_ver.pc

%files -n lib%name-gir
%_typelibdir/GstValidate-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/GstValidate-%api_ver.gir

%if_enabled doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/%name-%api_ver/
%_datadir/gtk-doc/html/%name-plugins-%api_ver/
%endif

%changelog
