Summary: Compatibility functions for RH/Fedora /etc/init.d/ scripts to work in ALT
Name: initscripts-compat-fedora
Version: 9.72
License: GPLv2
Group: System/Base
Release: alt1
URL: https://github.com/fedora-sysv/initscripts

# These compatibility functions are made available
# through sourcing the standard ALT's file:
Requires: %_initdir/functions
# Our file used to belong there:
Conflicts: service < 0.5.27

%global __find_provides /usr/lib/rpm/shell.prov %buildroot%_initdir/.provides.sh.compat | grep -e '([A-Za-z]'

BuildArch: noarch

Source: https://github.com/fedora-sysv/initscripts/archive/%{version}.tar.gz#/initscripts-%{version}.tar.gz
Patch: initscripts-9.72-alt-funcs-compat.patch

%global _unpackaged_files_terminate_build 1

# For %_initdir/.list.functions:
BuildPreReq: service >= 0.5.26-alt2

%description
Compatibility functions for 3rd-party /etc/init.d/ scripts
(written for RH/Fedora) to work in ALT.

These compatibility functions are made available through
sourcing the standard ALT's file: %_initdir/functions

%prep
%setup -q -n initscripts-%version
%patch -p1

%install
mkdir -p %buildroot%_initdir
install -m0644 rc.d/init.d/functions -T %buildroot%_initdir/functions-compat

# Generate shell functions provides list.
export LC_COLLATE=C

print_function_names()
{
        sed -ne 's/^[[:space:]]*\(function[[:space:]]\+\)\?\([A-Za-z_0-9]*[A-Za-z_][A-Za-z_0-9]*[[:space:]]*\)()[[:space:]]*\({.*\)\?$/\2/pg' "$1"
}

print_function_names %buildroot%_initdir/functions-compat |
sort -u \
>%buildroot%_initdir/.list.functions-compat

(
        echo '# shell functions provides list'
        comm -1 -3 \
        %_initdir/.list.functions \
        %buildroot%_initdir/.list.functions-compat
) >%buildroot%_initdir/.provides.sh.compat

%files
%_initdir/functions-compat

# Can be used to generate other lists when building the next release of service:
%_initdir/.list.functions-compat
%_initdir/.provides.sh.compat

%changelog
