
Name: ipmiutil
Version: 3.1.3
Release: alt2

Summary: IPMI server management utilities
License: BSD
Group: System/Kernel and hardware

Url: http://ipmiutil.sf.net
Source: http://prdownloads.sf.net/ipmiutil/%name-%version.tar.gz

# Automatically added by buildreq on Sat Oct 08 2011
# optimized out: libstdc++-devel
BuildRequires: gcc-c++ libssl-devel openssl

%add_findreq_skiplist %_datadir/%name/*

%description
The ipmiutil component package provides utilities to view the SEL
(showsel), perform a hardware reset (hwreset), set up the BMC LAN
and Platform Event Filter entry to allow SNMP alerts (pefconfig),
and other IPMI tasks.  These can be invoked with the metacommand,
ipmiutil, as well.  Man pages are provided.

An IPMI driver can be provided by either the Intel IPMI driver
(/dev/imb) or the OpenIPMI driver (/dev/ipmi0).  If used locally
and no driver is detected, ipmiutil will use user-space register
I/Os instead.

%package -n lib%name
Group: System/Libraries
Summary:  Includes libraries and headers for the ipmiutil package

%description -n lib%name
The package contains libraries which are
useful for building custom IPMI applications.

%package -n lib%name-devel
Group: Development/C
Summary:  Includes libraries and headers for the ipmiutil package
Requires: lib%name = %EVR

%description -n lib%name-devel
The ipmiutil-devel package contains headers and libraries which are
useful for building custom IPMI applications.

%package -n lib%name-devel-static
Group: Development/C
Summary:  Includes static libraries for the ipmiutil package
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
The ipmiutil-static package contains static libraries which are
useful for building custom IPMI applications.

%package cronjob
Summary: A periodic job to syslog and clear SEL records
Group: Monitoring
BuildArch: noarch

%description cronjob
This package contains a daily cron script which runs ipmiutil sel,
writing any new records to syslog, and will then clear the SEL
if free space is low.

The IPMI SEL should not normally be cleared, because the history
of the events is important, but if the IPMI SEL fills up, no new
events are logged, so saving the previous SEL events and clearing
the SEL must be done occasionally, as needed.

%prep
%setup
# Makefile uses the TMPDIR environment variable, the same is used
# by the Elbrus compiler to set the directory for temporary files.
sed -i "s|TMPDIR|TMPDIR1|g" Makefile*

%build
export NPROCS=8
./beforeconf.sh
%configure --enable-gpl
%make_build

%install
%makeinstall_std
install -pDm755 scripts/checksel %buildroot%_sysconfdir/cron.daily/checksel
install -dm700 %buildroot%_localstatedir/%name

%files
%_bindir/*
%_sbindir/*
%_man8dir/*
%attr(700,root,root) %_localstatedir/%name/

%files -n lib%name
%_libdir/libipmiutil.so.*

%files -n lib%name-devel
%_datadir/%name
%_libdir/libipmiutil.so
%_includedir/ipmicmd.h

%files -n lib%name-devel-static
%_libdir/libipmiutil.a

%files cronjob
%_sysconfdir/cron.daily/checksel

%changelog
