%define _unpackaged_files_terminate_build 1

%define oname ipython

%def_without doc

Name: ipython3
Version: 7.18.1
Release: alt4
Summary: An enhanced interactive Python 3 shell
License: BSD-3-Clause
Group: Development/Python3
Url: https://ipython.org

BuildArch: noarch

# https://github.com/ipython/ipython.git
Source: %name-%version.tar
Patch1: %name-%version-alt-docs.patch
Patch2: %name-alt-dont-import-tests.patch

%add_findreq_skiplist %python3_sitelibdir/IPython/utils/eventful.py

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3(prompt_toolkit)
BuildRequires: python3(backcall)

%if_with doc
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx-devel python3-module-matplotlib-sphinxext python3-module-numpydoc
BuildRequires: python3(sphinx_rtd_theme) graphviz
%endif

%add_python3_req_skip __main__
%add_python3_req_skip Gnuplot Numeric bzrlib foolscap nose setuptools twisted
%add_python3_req_skip msvcrt wx gtk compiler OpenGL oct2py rpy2
%add_python3_req_skip System clr

Requires: python3-module-%oname = %EVR

Conflicts: ipython

%description
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

Main features:
* Comprehensive object introspection.
* Input history, persistent across sessions.
* Caching of output results during a session with automatically generated
  references.
* Readline based name completion.
* Extensible system of 'magic' commands for controlling the environment and
  performing many tasks related either to IPython or the operating system.
* Configuration system with easy switching between different setups (simpler
  than changing $$PYTHONSTARTUP environment variables every time).
* Session logging and reloading.
* Extensible syntax processing for special purpose situations.
* Access to the system shell with user-extensible alias system.
* Easily embeddable in other Python programs.
* Integrated access to the pdb debugger and the Python profiler.

%package doc
Summary: IPython documentation
Group: Development/Python3

%description doc
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains IPython documentation (html and PDF formats).

%package examples
Summary: IPython examples
Group: Development/Python3

%description examples
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains examples for IPython.

%package -n python3-module-%oname
Summary: An enhanced interactive Python 3 shell
Group: Development/Python3

%description -n python3-module-%oname
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains modules for Python-3.

%package -n python3-module-%oname-tests
Summary: An enhanced interactive Python 3 shell
Group: Development/Python3

%description -n python3-module-%oname-tests
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains tests for Python-3.

%prep
%setup
%patch1 -p1
%patch2 -p1

%if_with doc
%prepare_sphinx3 docs
ln -s ../objects.inv docs/source/
%endif

%build
export LANG="en_US.UTF-8"
%python3_build

%install
export LANG="en_US.UTF-8"
%python3_install

%if_with doc
install -d %buildroot%_docdir/%name
cp docs/source/*.txt %buildroot%_docdir/%name/

export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs html
cp -R docs/build/html/* examples %buildroot%_docdir/%name/
%endif

%files
%doc COPYING.rst LICENSE
%doc README.rst
%_bindir/*
%_man1dir/*
%if_with doc
%dir %_docdir/%name
%_docdir/%name/*.txt
%endif

%files -n python3-module-%oname
%python3_sitelibdir/IPython
%python3_sitelibdir/%oname-%version-py*.egg-info
# everything except for skipdoctest.py from IPython/testing is packaged into tests package
%exclude %python3_sitelibdir/IPython/testing/plugin
%exclude %python3_sitelibdir/IPython/testing/__init__.py
%exclude %python3_sitelibdir/IPython/testing/__main__.py
%exclude %python3_sitelibdir/IPython/testing/decorators.py
%exclude %python3_sitelibdir/IPython/testing/globalipapp.py
%exclude %python3_sitelibdir/IPython/testing/iptest.py
%exclude %python3_sitelibdir/IPython/testing/iptestcontroller.py
%exclude %python3_sitelibdir/IPython/testing/ipunittest.py
%exclude %python3_sitelibdir/IPython/testing/tools.py
%exclude %python3_sitelibdir/IPython/testing/__pycache__/__init__.*
%exclude %python3_sitelibdir/IPython/testing/__pycache__/__main__.*
%exclude %python3_sitelibdir/IPython/testing/__pycache__/decorators.*
%exclude %python3_sitelibdir/IPython/testing/__pycache__/globalipapp.*
%exclude %python3_sitelibdir/IPython/testing/__pycache__/iptest.*
%exclude %python3_sitelibdir/IPython/testing/__pycache__/iptestcontroller.*
%exclude %python3_sitelibdir/IPython/testing/__pycache__/ipunittest.*
%exclude %python3_sitelibdir/IPython/testing/__pycache__/tools.*
%exclude %python3_sitelibdir/IPython/*/tests
%exclude %python3_sitelibdir/IPython/external/decorators
%exclude %python3_sitelibdir/IPython/conftest.py
%exclude %python3_sitelibdir/IPython/__pycache__/conftest.*

%files -n python3-module-%oname-tests
%python3_sitelibdir/IPython/testing/plugin
%python3_sitelibdir/IPython/testing/__init__.py
%python3_sitelibdir/IPython/testing/__main__.py
%python3_sitelibdir/IPython/testing/decorators.py
%python3_sitelibdir/IPython/testing/globalipapp.py
%python3_sitelibdir/IPython/testing/iptest.py
%python3_sitelibdir/IPython/testing/iptestcontroller.py
%python3_sitelibdir/IPython/testing/ipunittest.py
%python3_sitelibdir/IPython/testing/tools.py
%python3_sitelibdir/IPython/testing/__pycache__/__init__.*
%python3_sitelibdir/IPython/testing/__pycache__/__main__.*
%python3_sitelibdir/IPython/testing/__pycache__/decorators.*
%python3_sitelibdir/IPython/testing/__pycache__/globalipapp.*
%python3_sitelibdir/IPython/testing/__pycache__/iptest.*
%python3_sitelibdir/IPython/testing/__pycache__/iptestcontroller.*
%python3_sitelibdir/IPython/testing/__pycache__/ipunittest.*
%python3_sitelibdir/IPython/testing/__pycache__/tools.*
%python3_sitelibdir/IPython/*/tests
%python3_sitelibdir/IPython/external/decorators
%python3_sitelibdir/IPython/conftest.py
%python3_sitelibdir/IPython/__pycache__/conftest.*

%if_with doc
%files doc
%_docdir/%name
%exclude %_docdir/%name/*.txt
%exclude %_docdir/%name/examples

%files examples
%dir %_docdir/%name
%_docdir/%name/examples
%endif

%changelog
