%define rname ki18n
%def_disable python
%if_enabled python
%define sipver2 %(rpm -q --qf '%%{VERSION}' python-module-sip)
%define sipver3 %(rpm -q --qf '%%{VERSION}' python3-module-sip)
%endif
%add_python3_path %_libdir/cmake

Name: kf5-%rname
Version: 5.116.0
Release: alt1
%K5init altplace

Group: System/Libraries
Summary: KDE Frameworks 5 gettext-based UI text internationalization
Url: http://www.kde.org
License: LGPL-2.0-or-later

Source: %rname-%version.tar
Patch1: alt-fallback.patch

# Automatically added by buildreq on Tue Feb 10 2015 (-bi)
# optimized out: cmake cmake-modules elfutils libcloog-isl4 libqt5-concurrent libqt5-core libqt5-script libqt5-test libstdc++-devel python-base python-modules qt5-base-devel ruby ruby-stdlibs
#BuildRequires: extra-cmake-modules gcc-c++ python-module-google python-modules-encodings qt5-script-devel rpm-build-gir rpm-build-ruby
BuildRequires(pre): rpm-build-kf5
BuildRequires(pre): rpm-build-python3 python3-module-sip-devel
BuildRequires: extra-cmake-modules gcc-c++ qt5-script-devel qt5-declarative-devel
BuildRequires: python3-module-PyQt5-devel

%description
KI18n provides functionality for internationalizing user interface text
in applications, based on the GNU Gettext translation system.
It wraps the standard Gettext functionality, so that the programmers
and translators can use the familiar Gettext tools and workflows.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5i18n
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5i18n
KF5 library

%package -n libkf5i18nlocaledata
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5i18nlocaledata
KF5 library

%if_enabled python
%package -n python-module-%rname
Summary: Python bindings for KI18n
License: GPLv2+ / LGPLv2+
Group: Development/Python
Requires: %name-common = %version-%release
Requires: python-module-pykf5
Requires: python-module-sip = %sipver2
%description -n python-module-%rname
Python bindings for KI18n

%package -n python-module-%rname-devel
Summary: Sip files for python-module-%rname
Group: Development/Python
BuildArch: noarch
%description -n python-module-%rname-devel
Sip files for python-module-%rname

%package -n python3-module-%rname
Summary: Python3 bindings for KI18n
License: GPLv2+ / LGPLv2+
Group: Development/Python3
Requires: %name-common = %version-%release
Requires: python3-module-pykf5
Requires: python3-module-sip = %sipver3
%description -n python3-module-%rname
Python3 bindings for KI18n

%package -n python3-module-%rname-devel
Summary: Sip files for python3-module-%rname
Group: Development/Python3
BuildArch: noarch
%description -n python3-module-%rname-devel
Sip files for python3-module-%rname
%endif

%prep
%setup -n %rname-%version
%patch1 -p1

%if_disabled python
sed -i 's|PythonModuleGeneration|PythonModuleGeneration_DISABLED|' src/CMakeLists.txt
%endif

%build
%K5build

%install
%K5install
%K5install_move data locale
%find_lang %name --all-name
%K5find_qtlang %name --all-name
rm -rf %buildroot%_libdir/*/*/*/__*


%files common -f %name.lang
%doc LICENSES/* README.md
%dir %_K5i18n/*/
%dir %_K5i18n/*/LC_MESSAGES/
%_K5i18n/*/LC_SCRIPTS/
%_datadir/qlogging-categories5/*.*categories

%files devel
#%_K5inc/ki18n_version.h
%_K5inc/KI18n/
%_K5inc/KI18nLocaleData/
%_K5link/lib*.so
%_K5lib/cmake/KF5I18n/
%_K5archdata/mkspecs/modules/qt_KI18n.pri

%files -n libkf5i18n
%_K5lib/libKF5I18n.so.*
%_K5plug/kf5/ktranscript.so
%files -n libkf5i18nlocaledata
%_K5lib/libKF5I18nLocaleData.so.*
%_K5qml/org/kde/i18n/localeData/

%if_enabled python
#%files -n python-module-%rname
#%python_sitelibdir/PyKF5/*.so
#%files -n python-module-%rname-devel
#%_datadir/sip/PyKF5/KI18n/
%files -n python3-module-%rname
%python3_sitelibdir/PyKF5/*.so
%files -n python3-module-%rname-devel
%_datadir/sip3/PyKF5/KI18n/
%endif

%changelog
