Name: libbabl
Version: 0.1.106
Release: alt1
Summary: babl is a dynamic, any to any, pixel format translation library
License: %lgpl3only
Group: System/Libraries
Url: http://www.gegl.org/babl/
Packager: Valery Inozemtsev <crux@altlinux.ru>

Source: babl-%version.tar
Patch: babl-%version-%release.patch

BuildRequires(pre): rpm-build-licenses meson
BuildRequires: gobject-introspection-devel liblcms2-devel librsvg-utils w3m inkscape ruby vala-tools

%description
babl is a dynamic, any to any, pixel format translation library.

It allows converting between different methods of storing pixels known as pixel
formats that have with different bitdepths and other data representations, color
models and component permutations.

A vocabulary to formulate new pixel formats from existing primitives is provided
as well as the framework to add new color models and data types.

Features
 * Fast.
 * Accurate.
 * Stable, small API.
 * Self profiling and optimizing.
 * ANSI C, works on win32, linux and mac, 32bit and 64bit systems.
 * Extendable with new formats, color models, components and datatypes.
 * Reference 64bit floating point conversions for datatypes and color models.

%package gir
Summary: GObject introspection data for babl
Group: System/Libraries

%description gir
GObject introspection data for babl

%package devel
Summary: development files of babl
Group: Development/C
Requires: %name = %version-%release

%description devel
babl is a dynamic, any to any, pixel format translation library. This package
contain development files.

%prep
%setup -q -n babl-%version
%patch -p1

%build
sed "s|@BABL_GIT_VERSION@|%version|" git-version.h.in > git-version.h
%meson \
	-Dwith-docs=false
%meson_build -v

%install
%meson_install

%files
%doc AUTHORS COPYING NEWS TODO
%_bindir/babl
%_libdir/*.so.*
%dir %_libdir/babl-0.1
%_libdir/babl-0.1/*.so

%files gir
%_libdir/girepository-1.0/*.typelib

%files devel
%_includedir/babl-0.1
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/gir-1.0/*.gir
%_vapidir/babl-*.deps
%_vapidir/babl-*.vapi

%changelog
