Name: libburn
Version: 1.5.4
Release: alt1

Summary: CD/DVD-R/RW disc reading/writing library
License: %gpl2plus
Group: System/Libraries
Url: https://dev.lovelyhq.com/libburnia/web/wikis/home

#VCS: https://dev.lovelyhq.com/libburnia/libburn.git
Source: %name-%version.tar

Packager: Anton V. Boyrahinov <boyarsh@altlinux.org>

BuildRequires(pre): rpm-build-licenses

%description
libburnia.pykix.org is an open-source software project for reading, mastering
and writing optical discs. For now this means only CD-R, CD-RW, DVD-RAM,
DVD+RW, DVD-RW.

The project comprises of several more or less interdependent parts which
together strive to be a usable foundation for application development.
These are libraries, language bindings, and middleware binaries which emulate
classical (and valuable) Linux tools.

Our scope is currently Linux 2.4 and 2.6 only. For ports to other systems
we would need : login on a development machine resp. a live OS on CD or DVD,
advise from a system person about the equivalent of Linux sg or FreeBSD CAM,
volunteers for testing of realistic use cases.

We have a workable code base for burning CDs and overwriteable DVDs, though.
The burn API is quite comprehensively documented and can be used to build a
presentable application.
We have a functional binary which emulates parts of cdrecord in order to
prove that usability, and in order to allow you to explore libburnia's scope
by help of existing cdrecord frontends.

%package devel
Summary: Development files for libburn
Group: Development/C
Requires: %name = %version-%release

%description devel
libburnia.pykix.org is an open-source software project for reading, mastering
and writing optical discs. For now this means only CD-R, CD-RW, DVD-RAM,
DVD+RW, DVD-RW.

The project comprises of several more or less interdependent parts which
together strive to be a usable foundation for application development.
These are libraries, language bindings, and middleware binaries which emulate
classical (and valuable) Linux tools.

Our scope is currently Linux 2.4 and 2.6 only. For ports to other systems
we would need : login on a development machine resp. a live OS on CD or DVD,
advise from a system person about the equivalent of Linux sg or FreeBSD CAM,
volunteers for testing of realistic use cases.

We have a workable code base for burning CDs and overwriteable DVDs, though.
The burn API is quite comprehensively documented and can be used to build a
presentable application.
We have a functional binary which emulates parts of cdrecord in order to
prove that usability, and in order to allow you to explore libburnia's scope
by help of existing cdrecord frontends.

%package -n cdrskin
Summary: minimal cdrecord implementation based on libburn
Group: Archiving/Cd burning
Requires: %name = %version

%description -n cdrskin
cdrskin  is a limited cdrecord compatibility wrapper for libburn.
Cdrecord is a powerful GPL'ed burn program included in Joerg
Schilling's cdrtools. cdrskin strives to be a second source for
the services traditionally provided by cdrecord.
cdrskin does not contain any bytes copied from cdrecord's sources.
Many bytes have been copied from the message output of cdrecord
runs, though.

%prep
%setup

%build
%autoreconf
%configure \
	--disable-static

%make_build

%install
%makeinstall_std

%files
%_libdir/%name.so.*

%files devel
%dir %_includedir/%name
%_includedir/%name/%name.h
%_libdir/%name.so
%_pkgconfigdir/*.pc

%files -n cdrskin
%_bindir/cdrskin
%_man1dir/*

%changelog
