%def_disable snapshot
%define ver_major 1.5
%def_enable x11
%def_enable glx
%def_enable egl
%def_disable docs
%def_enable check

Name: libepoxy
Version: %ver_major.9
Release: alt1

Summary: Direct Rendering Manager runtime library
Group: System/Libraries
License: MIT
Url: https://github.com/anholt/libepoxy

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Vcs: https://github.com/anholt/libepoxy.git
Source: %name-%version.tar
%endif

BuildRequires(pre): meson >= 0.54
BuildRequires: python3 libglvnd-devel libGL-devel
%{?_enable_x11:BuildRequires: libX11-devel xorg-util-macros}
%{?_enable_egl:BuildRequires: libEGL-devel}
%{?_enable_docs:BuildRequires: doxygen}

%description
A library for handling OpenGL function pointer management.

%package devel
Summary: Development files for libepoxy
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: Development files for libepoxy
Group: Development/Documentation
Conflicts: %name < %version

%description devel-doc
This package contains development documentation for %name.

%prep
%setup

%build
%meson \
	%{?_disable_x11:-Dx11=false} \
	%{?_enable_glx:-Dglx=yes} \
	%{?_enable_egl:-Degl=yes} \
	%{?_enable_docs:-Ddocs=true}
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot/%_libdir
%meson_test

%files
%_libdir/%name.so.*
%doc README.md COPYING

%files devel
%_includedir/epoxy/
%_libdir/%name.so
%_pkgconfigdir/epoxy.pc

%if_enabled docs
%files devel-doc
%_datadir/doc/epoxy/
%endif


%changelog
