%def_disable snapshot

%define _name gtk+
%define ver_major 3.24
%define api_ver 3.0
%define binary_ver 3.0.0
%define _libexecdir %_prefix/libexec

%def_enable xkb
%def_disable static
%def_disable gtk_doc
%def_enable man
%def_enable introspection
%def_enable colord
# wayland gdk backend
%def_enable wayland
# broadway (HTML5) gdk backend
%def_enable broadway
%def_disable cloudproviders
%def_disable tracker3
%def_enable installed_tests
%def_disable debug

Name: libgtk+3
Version: %ver_major.32
Release: alt1

Summary: The GIMP ToolKit (GTK+)
Group: System/Libraries
License: %lgpl2plus
Url: http://www.gtk.org

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz
%endif
Source5: gtk-icon-cache.filetrigger

Patch: gtk+-2.16.5-alt-stop-spam.patch
# move cloudproviders flags from gdk to gtk
Patch1: gtk+-3.24.9-alt-build.patch

%define glib_ver 2.58
%define gi_ver 1.41.0
%define cairo_ver 1.14.0
%define pango_ver 1.42.0
%define atk_ver 2.15.1
%define atspi_ver 2.8.1
%define pixbuf_ver 2.36.3
%define fontconfig_ver 2.2.1-alt2
%define gtk_doc_ver 1.20
%define colord_ver 0.1.9
%define cups_ver 1.7
%define wayland_ver 1.10.0
%define wayland_protocols_ver 1.14
%define epoxy_ver 1.4
%define cloudproviders_ver 0.2.5
%define fribidi_ver 0.19.7

Provides: libgtk3-engine-adwaita = %EVR
Obsoletes: libgtk3-engine-adwaita < 3.13.0
#https://bugzilla.altlinux.org/39393
Provides: gtk3 = %EVR

Requires: %name-schemas = %EVR
Requires: gtk-update-icon-cache = %EVR
Requires: icon-theme-adwaita
# ALT #32028
Requires: gtk+3-themes-incompatible
%{?_enable_colord:Requires: colord}

BuildRequires(pre): rpm-build-licenses rpm-build-gnome rpm-build-gir
BuildRequires: glib2-devel >= %glib_ver libgio-devel
BuildRequires: libcairo-devel >= %cairo_ver
BuildRequires: libcairo-gobject-devel >= %cairo_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libatk-devel >= %atk_ver
BuildRequires: at-spi2-atk-devel >= %atspi_ver
BuildRequires: libgdk-pixbuf-devel >= %pixbuf_ver
BuildRequires: fontconfig-devel >= %fontconfig_ver
BuildRequires: gtk-doc >= %gtk_doc_ver
BuildRequires: libcups-devel >= %cups_ver
BuildRequires: libepoxy-devel >= %epoxy_ver
BuildRequires: docbook-utils zlib-devel
BuildRequires: sassc
BuildRequires: libXdamage-devel libXcomposite-devel libX11-devel libXcursor-devel
BuildRequires: libXext-devel libXfixes-devel libXi-devel libXinerama-devel libXrandr-devel
BuildRequires: libXrender-devel libXt-devel
BuildRequires: libfribidi-devel >= %fribidi_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver libpango-gir-devel libatk-gir-devel >= %atk_ver libgdk-pixbuf-gir-devel}
%{?_enable_colord:BuildRequires: libcolord-devel >= %colord_ver}
%{?_enable_wayland:BuildRequires: libwayland-client-devel >= %wayland_ver libwayland-cursor-devel libEGL-devel libwayland-egl-devel libxkbcommon-devel wayland-protocols >= %wayland_protocols_ver}
%{?_enable_cloudproviders:BuildRequires: libcloudproviders-devel >= %cloudproviders_ver}
%{?_enable_tracker3:BuildRequires: pkgconfig(tracker-sparql-3.0)}
# for examples
BuildRequires: libcanberra-gtk3-devel libharfbuzz-devel
# for check
BuildRequires: /proc dbus-tools-gui xvfb-run icon-theme-hicolor gnome-icon-theme-symbolic

%description
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
Offering a complete set of widgets, GTK+ is suitable for projects
ranging from small one-off projects to complete application suites.

This package contains X11 part of GTK+. It is required for GNOME 3 desktop
and programs.

%package schemas
Summary: GSettings schemas used by GTK+3
Group: System/Libraries
Requires: dconf
BuildArch: noarch

%description schemas
This package provides a set of GTK+3 GSettings schemas.

%package -n gtk-update-icon-cache
Summary: Icon theme caching utility for GTK+
Group: System/Libraries

%description -n gtk-update-icon-cache
gtk-update-icon-cache creates mmap()able cache files for icon themes.
GTK+ can use the cache files created by gtk-update-icon-cache to avoid
a lot of system call and disk seek overhead when the application starts.

%package devel
Summary: Development files and tools for GTK+ applications
Group: Development/C
Requires: %name = %EVR
Requires: gtk-builder-convert

%description devel
This package contains development files for GTK+, X11 version. Use this to
build programs that use GTK+.

%package -n gtk3-demo
Summary: GTK+ widgets demonstration program
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description -n gtk3-demo
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains a program, along with its source code, that
demonstrates GTK+ variety of all its widgets.

%package -n %name-devel-doc
Summary: Development documentation for GTK+
Group: Development/Documentation
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description -n %name-devel-doc
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains documentation needed for developing GTK+ applications.

%package -n %name-devel-doc-examples
Summary: Examples for developing applications which will use GTK+
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description -n %name-devel-doc-examples
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains sources for example programs.

%package -n %name-devel-static
Summary: Static libraries for GTK+ (GIMP ToolKit) applications
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description -n %name-devel-static
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains the static libraries for GTK+.

%package gir
Summary: GObject introspection data for the GTK+ library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the GTK+ library

%package gir-devel
Summary: GObject introspection devel data for the GTK+ library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the GTK+ library

%package -n libgail3
Summary: Accessibility implementation for GTK+ and GNOME libraries
Group: System/Libraries
Requires: %name = %EVR

%description -n libgail3
GAIL implements the abstract interfaces found in ATK for GTK+ and GNOME libraries,
enabling accessibility technologies such as at-spi to access those GUIs.

%package -n libgail3-devel
Summary: Files to compile applications that use GAIL
Group: Development/GNOME and GTK+
Requires: libgail3 = %EVR
Requires: %name-devel = %EVR

%description -n libgail3-devel
This package contains the files required to develop applications against
the GAIL libraries.

%package -n libgail3-devel-static
Summary: Static libraries of GAIL
Group: Development/GNOME and GTK+
Requires: libgail3-devel = %EVR

%description -n libgail3-devel-static
This package contains the libraries required to compile applications
statically linked against the GAIL libraries.

%package -n libgail3-devel-doc
Summary: Development documentation for GAIL
Group: Development/Documentation
Conflicts: libgail3-devel < %version-%release
BuildArch: noarch

%description -n libgail3-devel-doc
GAIL implements the abstract interfaces found in ATK for GTK+ and GNOME
libraries, enabling accessibility technologies such as at-spi to access
those GUIs.

This package contains development documentation for GAIL.

%package tests
Summary: Tests for the GTK+3 packages
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed GTK+3 packages.


%define fulllibpath %_libdir/gtk-%api_ver/%binary_ver

%prep
%setup -n %_name-%version
%patch -p1
#%%patch1 -b .cloudprov
# fix wrong GLIB define names
sed -i.glib -e "s|GLIB_MIN_REQUIRED_VERSION|GLIB_VERSION_MIN_REQUIRED|" \
     -e "s|GLIB_MAX_ALLOWED_VERSION|GLIB_VERSION_MAX_ALLOWED|" \
     meson.build configure{,.ac}

%{?_enable_snapshot:touch README INSTALL}

%build
%{?_disable_static:export lt_cv_prog_cc_static_works=no}
%{?_enable_static:export lt_cv_prog_cc_static_works=yes}
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_enable man} \
    --enable-x11-backend \
    %{subst_enable xkb} \
    --disable-schemas-compile \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{?_enable_snapshot:--enable-gtk-doc} \
    %{subst_enable colord} \
    %{?_enable_wayland:--enable-wayland-backend} \
    %{?_enable_broadway:--enable-broadway-backend} \
    %{?_enable_installed_tests:--enable-installed-tests} \
    %{?_enable_tracker3:--enable-tracker3=yes} \
    %{?_enable_debug:--enable-debug=yes}
%make_build

# bad logic in configure.ac, fix it later
#    %{?_disable_cloudproviders:--enable-cloudproviders=no} \
#    %{subst_enable cloudproviders} \

%install
%makeinstall_std
install -d %buildroot{%_sysconfdir/gtk-%api_ver,%_libdir/gtk-%api_ver/%binary_ver/engines}

# posttransfiletrigger for update icons cache
install -pD -m755 {%_sourcedir,%buildroot%_rpmlibdir}/gtk-icon-cache.filetrigger

touch %buildroot%_libdir/gtk-%api_ver/%binary_ver/immodules.cache
# posttransfiletrigger to update immodules cache
cat <<EOF > filetrigger
#!/bin/sh -e

dir=%fulllibpath/immodules
grep -qs '^'\$dir'' && %_bindir/gtk-query-immodules-%api_ver --update-cache ||:
EOF

install -pD -m 755 filetrigger %buildroot%_rpmlibdir/gtk-%api_ver-immodules-cache.filetrigger

# system wide gtkrc
cat <<__RC__ > %buildroot%_sysconfdir/gtk-%api_ver/gtkrc
# This enables editing of menu accelerators by pressing
# an accelerator over the menu item.
gtk-can-change-accels = 1
__RC__

# The license
ln -sf %_licensedir/LGPL-2 COPYING

%find_lang --output=gtk30.lang gtk30 gtk30-properties
%find_lang --output=gail.lang gail

bzip2 -9kf NEWS

mkdir %buildroot%_libdir/gtk-%api_ver/modules

# examples
mkdir -p %buildroot/%_docdir/%name-devel-%version/examples
cp examples/*.c examples/Makefile* %buildroot/%_docdir/%name-devel-%version/examples/

%check
#xvfb-run %make check

%files -f gtk30.lang
%{?_enable_broadway:%_bindir/broadwayd}
%_bindir/gtk-query-immodules-%api_ver
%_bindir/gtk-query-settings
%_bindir/gtk-launch
%_bindir/gtk-encode-symbolic-svg
%_libdir/libgdk-3.so.*
%_libdir/libgtk-3.so.*
%dir %_libdir/gtk-%api_ver/modules
%dir %fulllibpath
%dir %fulllibpath/engines
%dir %fulllibpath/immodules
%fulllibpath/immodules/im-am-et.so
%fulllibpath/immodules/im-cedilla.so
%fulllibpath/immodules/im-cyrillic-translit.so
%fulllibpath/immodules/im-inuktitut.so
%fulllibpath/immodules/im-ipa.so
%fulllibpath/immodules/im-thai.so
%fulllibpath/immodules/im-ti-er.so
%fulllibpath/immodules/im-ti-et.so
%fulllibpath/immodules/im-viqr.so
%fulllibpath/immodules/im-multipress.so
%fulllibpath/immodules/im-wayland.so
%fulllibpath/immodules/im-waylandgtk.so
%fulllibpath/immodules/im-xim.so
%{?_enable_broadway:%fulllibpath/immodules/im-broadway.so}
%dir %fulllibpath/printbackends
%fulllibpath/printbackends/libprintbackend-*.so
%dir %_datadir/themes/*/gtk-%{api_ver}*
%_datadir/themes/*/gtk-%{api_ver}/*.css
%dir %_sysconfdir/gtk-%api_ver
%config(noreplace) %_sysconfdir/gtk-%api_ver/gtkrc
%config(noreplace) %_sysconfdir/gtk-%api_ver/im-multipress.conf
%ghost %_libdir/gtk-%api_ver/%binary_ver/immodules.cache
%{?_enable_broadway:%_man1dir/broadwayd.1.*}
%_man1dir/gtk-query-immodules*
%_man1dir/gtk-query-settings.1.*
%_man1dir/gtk-launch.*
%_man1dir/gtk-encode-symbolic-svg.1.*
%_rpmlibdir/gtk-%api_ver-immodules-cache.filetrigger
%doc --no-dereference COPYING
%doc AUTHORS NEWS.bz2 README

%files schemas
%config %_datadir/glib-2.0/schemas/org.gtk.Settings.FileChooser.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gtk.Settings.ColorChooser.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gtk.Settings.Debug.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gtk.Settings.EmojiChooser.gschema.xml

%files -n gtk-update-icon-cache
%_bindir/gtk-update-icon-cache
%_man1dir/gtk-update-icon-cache*
%_rpmlibdir/gtk-icon-cache.filetrigger

%files devel
%_bindir/gtk-builder-tool
%_includedir/gtk-%api_ver/
%_libdir/libgdk-3.so
%_libdir/libgtk-3.so
%_pkgconfigdir/gtk+-%api_ver.pc
%_pkgconfigdir/gtk+-x11-%api_ver.pc
%_pkgconfigdir/gdk-%api_ver.pc
%_pkgconfigdir/gdk-x11-%api_ver.pc
%_pkgconfigdir/gtk+-unix-print-%api_ver.pc
%dir %_datadir/gtk-%api_ver
%_datadir/gtk-%api_ver/gtkbuilder.rng
%_datadir/aclocal/gtk-%api_ver.m4
%_datadir/gettext/its/gtkbuilder.its
%_datadir/gettext/its/gtkbuilder.loc
%dir %_datadir/gtk-%api_ver/valgrind
%_datadir/gtk-%api_ver/valgrind/*.supp
%_man1dir/gtk-builder-tool.1*

%if_enabled wayland
%_pkgconfigdir/gtk+-wayland-%api_ver.pc
%_pkgconfigdir/gdk-wayland-%api_ver.pc
%endif

%if_enabled broadway
%_pkgconfigdir/gdk-broadway-3.0.pc
%_pkgconfigdir/gtk+-broadway-3.0.pc
%endif

%files -n gtk3-demo
%_desktopdir/gtk3-demo.desktop
%_desktopdir/gtk3-widget-factory.desktop
%_desktopdir/gtk3-icon-browser.desktop
%_bindir/gtk3-demo
%_bindir/gtk3-demo-application
%_bindir/gtk3-widget-factory
%_bindir/gtk3-icon-browser
%_datadir/glib-2.0/schemas/org.gtk.Demo.gschema.xml
%_iconsdir/hicolor/*x*/apps/gtk3-demo*.png
%_iconsdir/hicolor/*x*/apps/gtk3-widget*.png
%_man1dir/gtk3-demo.1.*
%_man1dir/gtk3-widget-factory.1.*
%_man1dir/gtk3-icon-browser.1.*
%_man1dir/gtk3-demo-application.1.*
%config %_datadir/glib-2.0/schemas/org.gtk.exampleapp.gschema.xml

%files devel-doc
%_datadir/gtk-doc/html/*
%exclude %_datadir/gtk-doc/html/gail-libgail-util3

%files devel-doc-examples
%doc %_docdir/%name-devel-%version/examples

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%fulllibpath/*/*.a

%files -n libgail3-devel-static
%_libdir/libgailutil.a
%endif

%files -n libgail3 -f gail.lang
%_libdir/libgailutil-3.so.*

%files -n libgail3-devel
%_includedir/gail-%api_ver
%_libdir/libgailutil-3.so
%_pkgconfigdir/gail-%api_ver.pc

%files -n libgail3-devel-doc
%_datadir/gtk-doc/html/gail-libgail-util3

%if_enabled introspection
%files gir
%_typelibdir/*

%files gir-devel
%_girdir/*
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/gtk+/
%_datadir/installed-tests/gtk+/
%endif

%exclude %fulllibpath/*/*.la

%changelog
