%def_disable snapshot
%define _name openshot

%define ver_major 0.2
%define api_ver 1.0

%def_enable python
%def_disable doc
%def_disable check

Name: lib%_name
Version: %ver_major.5
Release: alt3.1

Summary: OpenShot Video Library
Group: System/Libraries
License: GPL-3.0
Url: https://launchpad.net/%name

%if_disabled snapshot
#Source: %url/%ver_major/%version/+download/%name-%version.tar.gz
Source: https://github.com/OpenShot/%name/archive/v%version/%name-%version.tar.gz
%else
Vcs: https://github.com/OpenShot/libopenshot.git
Source: %name-%version.tar
%endif
Patch: libopenshot-0.2.4-alt-return-type.patch
Patch1: libopenshot-0.2.5-up-gcc10.patch

%define __python %nil
BuildRequires(pre): rpm-macros-cmake rpm-build-python3
BuildRequires: %name-audio-devel >= 0.1.9
BuildRequires: cmake gcc-c++ libgomp-devel libunittest-cpp-devel jsoncpp-devel
BuildRequires: qt5-multimedia-devel libzeromq-cpp-devel libImageMagick-devel
BuildRequires: libavcodec-devel libavformat-devel libavutil-devel
BuildRequires: libavresample-devel libswresample-devel libswscale-devel
BuildRequires: libavdevice-devel libpostproc-devel
%{?_enable_python:BuildRequires: python3-devel python3-module-zmq swig}
%{?_enable_check:BuildRequires: ctest ImageMagick-tools
#BuildRequires: catch2-devel}

%description
libopenshot is an open-source, cross-platform C++ library dedicated to
delivering high quality video editing, animation, and playback solutions
to the world. This is the same library which powers OpenShot Video Editor
(version 2.0+) and it could power your next video editing application!
C++, Python, and Ruby are fully supported, and other languages can be
added if requested.

%package devel
Summary: OpenShot Video Library development package
Group: Development/C++
Requires: %name = %version-%release

%description devel
This package contains development libraries and header files
that are needed to write applications that use %name.

%package -n python3-module-%_name
Summary: Python3 bindings for OpenShot Video Library
Group: Development/Python3
Requires: %name = %version-%release

%description -n python3-module-%_name
This package provides Python3 bindings for OpenShot Video Library.

%prep
%setup
%patch -b .return-type
%patch1 -p1 -b .gcc10

%build
%add_optflags %(getconf LFS_CFLAGS) -DNDEBUG
%cmake  -DUSE_SYSTEM_JSONCPP:BOOL=ON \
	-DMAGICKCORE_HDRI_ENABLE:BOOL=ON \
	-DMAGICKCORE_QUANTUM_DEPTH=16 \
	%{?_enable_python:-DENABLE_PYTHON=TRUE} \
	%{?_enable_check:-DENABLE_TESTS=TRUE}
%nil
%cmake_build

%install
%cmake_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%cmake_build -t test

%files
%_libdir/%name.so.*
%doc AUTHORS README*

%files devel
%_includedir/%name/
%_libdir/%name.so

%files -n python3-module-%_name
%python3_sitelibdir/*

%changelog
