%define _name pwquality
%def_disable python2

Name: lib%_name
Version: 1.4.4
Release: alt1

Summary: A library for password generation and password quality checking
License: BSD or GPL-2.0
Group: System/Libraries
Url: https://github.com/%name/%name/

Source: %url/releases/download/%name-%version/%name-%version.tar.bz2

Provides: pam_%_name = %version-%release
Requires: cracklib-words pam

BuildRequires: cracklib-devel pam-devel
BuildRequires: rpm-build-python3 python3-devel
%{?_enable_python2:BuildRequires: python-devel}

%description
This is a library for password quality checks and generation of random
passwords that pass the checks.
This library uses the cracklib and cracklib dictionaries to perform some
of the checks.

%package devel
Group: Development/C
Summary: Develompent files for %name
Requires: %name = %version-%release

%description devel
Files needed for development of applications using the %name library.
See the pwquality.h header file for the API.

%package -n python-module-%_name
Group: Development/Python
Summary: Python bindings for the %name library
Requires: %name = %version-%release

%description -n python-module-%_name
This is %_name Python module that provides Python bindings for the
%name library. These bindings can be used for easy password
quality checking and generation of random pronounceable passwords from
Python applications.

%package -n python3-module-%_name
Group: Development/Python
Summary: Python3 bindings for the %name library
Requires: %name = %version-%release

%description -n python3-module-%_name
This is %_name Python3 module that provides Python3 bindings for the
%name library. These bindings can be used for easy password
quality checking and generation of random pronounceable passwords from
Python3 applications.


%prep
%setup %{?_enable_python2:-a0
mv %name-%version py2build}

%build
%define opts --with-securedir=%_pam_modules_dir --disable-static


%configure \
	%opts \
	--with-python-binary=python3 \
	--with-pythonsitedir=%python3_sitelibdir
%make_build

%if_enabled python2
pushd py2build
%configure \
	%opts \
	--with-python-rev=2.7 \
	--with-pythonsitedir=%python_sitelibdir
%make_build
popd
%endif

%install
%makeinstall_std

%if_enabled python2
pushd py2build
%makeinstall_std
popd
%endif

# relocate %name.so.1 to %_lib
mkdir -p %buildroot/%_lib
mv %buildroot/%_libdir/%name.so.1* %buildroot/%_lib/
ln -sf ../../%_lib/%name.so.1 %buildroot%_libdir/%name.so

%find_lang %name

%check
%make check

%files -f libpwquality.lang
%_bindir/pwmake
%_bindir/pwscore
%_pam_modules_dir/pam_pwquality.so
/%_lib/%name.so.*
%config(noreplace) %_sysconfdir/security/%_name.conf
%_man1dir/*
%_man5dir/*
%_man8dir/*
%doc COPYING README NEWS AUTHORS

%exclude %_pam_modules_dir/*.la

%files devel
%_includedir/%_name.h
%_libdir/%name.so
%_pkgconfigdir/%_name.pc
%_man3dir/pwquality.3.*

%if_enabled python2
%files -n python-module-%_name
%python_sitelibdir/%_name.so
%python_sitelibdir/*.egg-info
%endif

%files -n python3-module-%_name
%python3_sitelibdir/%{_name}*.so
%python3_sitelibdir/*.egg-info

%changelog
