# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ pkgconfig(libsystemd) python3-devel
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with check

Name:           libqb
Version:        2.0.8
Release:        alt1_2
Summary:        Library providing high performance logging, tracing, ipc, and poll

License:        LGPL-2.1-or-later
URL:            https://github.com/ClusterLabs/libqb
Source0:        https://github.com/ClusterLabs/libqb/releases/download/v%{version}/%{name}-%{version}.tar.xz

#Patch0: connretry-recv.patch

BuildRequires:  autoconf automake libtool
BuildRequires:  libcheck-devel
BuildRequires:  doxygen
BuildRequires:  gcc
BuildRequires:  procps
# for ipc.test only (part of check scriptlet)
BuildRequires:  pkgconfig(glib-2.0)
# git-style patch application
BuildRequires:  git-core
# For doxygen2man
BuildRequires:  libxml2-devel
Source44: import.info

%description
A "Quite Boring" library that provides high-performance, reusable features for client-server
architecture, such as logging, tracing, inter-process communication (IPC),
and polling.

%package -n libqb100
Summary:        Shared library for the %name library
Group:          System/Libraries

%description -n libqb100
A "Quite Boring" library that provides high-performance, reusable features for client-server
architecture, such as logging, tracing, inter-process communication (IPC),
and polling.

This package contains the shared library.

%prep
%setup -q -n %{name}-%{version}
#%patch0 -p1 -b .connretry-recv.patch

%build
./autogen.sh
%configure --disable-static
%{make_build}

%install
%{makeinstall_std}
find $RPM_BUILD_ROOT -name '*.la' -delete
rm -rf $RPM_BUILD_ROOT/%{_docdir}/*



%files
%{_sbindir}/qb-blackbox
%{_mandir}/man8/qb-blackbox.8*

%files -n libqb100
%doc --no-dereference COPYING
%_libdir/libqb.so.100
%_libdir/libqb.so.100.*

%package        devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       libqb100 = %EVR
Requires:       pkgconfig

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%files          devel
%doc README.markdown
%{_includedir}/qb/
%{_libdir}/libqb.so
%{_libdir}/pkgconfig/libqb.pc
%{_mandir}/man3/qb*3*


%package -n     doxygen2man
Group: System/Libraries
Summary:        Program to create nicely-formatted man pages from Doxygen XML files
Requires:       libqb100 = %EVR


%description -n doxygen2man
This package contains a program to create nicely-formatted man pages from Doxygen XML files

%files -n       doxygen2man
%{_bindir}/doxygen2man
%{_mandir}/man1/doxygen2man.1*


%changelog
