%def_disable snapshot

%define ver_major 0.20
%define api_ver 1

%def_disable static
%def_enable introspection
%def_enable vala
%def_enable gtk_doc
%def_enable man
%def_disable check

Name: libsecret
Version: %ver_major.5
Release: alt1

Summary: A client library for the Secret Service DBus API
Group: System/Libraries
License: LGPL-2.1
Url: https://wiki.gnome.org/Projects/Libsecret

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Vcs: https://gitlab.gnome.org/GNOME/libsecret.git
Source: %name-%version.tar
%endif
Patch: %name-0.20.0-alt-python3_shebang.patch

%define glib_ver 2.44.0
%define vala_ver 0.17.2.12
%define gcrypt_ver 1.4.5

BuildRequires(pre): meson >= 0.50
BuildRequires(pre): rpm-macros-valgrind
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgcrypt-devel >= %gcrypt_ver
BuildRequires: libtpm2-tss-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools >= %vala_ver}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_man:BuildRequires: xsltproc docbook-style-xsl}
%{?_enable_check:
BuildRequires: /proc fuse-gvfs dbus-tools-gui python3-module-dbus-gobject
BuildRequires: python3-module-pygobject3 python3-module-mock libgjs}

%ifarch %valgrind_arches
BuildRequires: valgrind-devel
%endif

%description
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

%package devel
Summary: Development files and libraries for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

This package provides files for development with %name.

%package devel-doc
Summary: Development documentaion for %name
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
libsecrets is a client for the Secret Service DBus API. The Secret
Service allows storage of passwords in a common way on the desktop.
Supported by gnome-keyring and ksecretservice.

This package provides development documentations for %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name library.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for %name.

%prep
%setup
%patch -p1

%build
%meson \
%{?_disable_introspection:-Dintrospection=false} \
%{?_disable_vala:-Dvapi=false} \
%{?_disable_gtk_doc:-Dgtk_doc=false} \
%{?_disable_man:-Dmanpage=false}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
dbus-run-session %meson_test

%files -f %name.lang
%_bindir/secret-tool
%_libdir/%name-%api_ver.so.*
%{?_enable_man:%_man1dir/secret-tool.1.*}
%doc README* NEWS

%files devel
%_includedir/%name-%api_ver
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%_pkgconfigdir/%name-unstable.pc
%if_enabled vala
%_vapidir/%name-%api_ver.vapi
%_vapidir/%name-%api_ver.deps
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%name-%api_ver
%endif

%if_enabled introspection
%files gir
%_typelibdir/Secret-%api_ver.typelib

%files gir-devel
%_girdir/Secret-%api_ver.gir
%endif


%changelog
