%def_disable snapshot
%define _name soundtouch
%def_enable openmp
%def_enable check

Name: libsoundtouch
Version: 2.3.1
Release: alt2

Summary: SoundTouch audio processing library
Group: System/Libraries
License: LGPLv2.1

Url: http://www.surina.net/soundtouch/
%if_disabled snapshot
Source: https://gitlab.com/%_name/%_name/-/archive/%version/%_name-%version.tar.gz
%else
Vcs: https://gitlab.com/soundtouch/soundtouch
Source: %_name-%version.tar
%endif

BuildRequires: gcc-c++ libstdc++-devel
%{?_enable_openmp:BuildRequires: libgomp-devel}

%description
SoundTouch is an open-source audio processing library that allows changing
the sound tempo, pitch and playback rate parameters independently from
each other, i.e.:
 - Sound tempo can be increased or decreased while maintaining the original pitch
 - Sound pitch can be increased or decreased while maintaining the original tempo
 - Change playback rate that affects both tempo and pi

%package devel
Summary: Libraries/include files for development with %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Libraries/include files for development with %name.

%prep
%setup -n %_name-%version
%if_enabled openmp
%ifarch %e2k
# for unknown reason, libtool uses the -nostdlib option when linking,
# and -fopenmp is ignored in this case 
echo "libSoundTouch_la_LDFLAGS+=-lomp" >> source/SoundTouch/Makefile.am
%endif
%endif

%build
#touch NEWS README AUTHORS ChangeLog
#%autoreconf
./bootstrap
%configure --disable-static \
    %{subst_enable openmp}
%make_build

%install
%makeinstall_std
rm -rf %buildroot/%_prefix/doc

%check
%make check

%files
%_bindir/soundstretch
%_libdir/libSoundTouch.so.*
%doc README.html

%files devel
%_includedir/%_name/
%_libdir/libSoundTouch.so
%_aclocaldir/%_name.m4
%_pkgconfigdir/%_name.pc

%changelog
