%def_disable snapshot

%define _name libsoup
%define api_ver 3.0
%define ver_major 2.99
%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_enable vala
%def_with gssapi
%def_disable debug
%def_disable sysprof
%def_disable check

Name: %_name%api_ver
Version: %ver_major.8
Release: alt1

Summary: HTTP client/server library for GNOME
Group: System/Libraries
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/libsoup

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%endif

Requires: glib-networking >= 2.63.90

%define glib_ver 2.67.4
%define gi_ver 1.33.3
%define psl_ver 0.20.0

BuildRequires(pre): meson rpm-build-gir
BuildRequires: python3-base
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libxml2-devel libsqlite3-devel zlib-devel
BuildRequires: docbook-dtds docbook-style-xsl
BuildRequires: gtk-doc xml-common xsltproc
BuildRequires: glib-networking libpsl-devel >= %psl_ver
BuildRequires: libbrotli-devel libnghttp2-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_with_gssapi:BuildRequires: libkrb5-devel}
%{?_enable_sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}
%{?_enable_check:BuildRequires: /proc curl}

%description
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

%package devel
Summary: Headers for HTTP client/server library for GNOME
Group: Development/C
Requires: %name = %version-%release

%description devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package allows to develop applications that use the Soup library.

%package devel-doc
Summary: Development documentation for HTTP client/server library for GNOME
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package contains development documentation for Soup.

%package devel-static
Summary: Headers for Simple Object Access Protocol static library
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package allows to develop applications that statically linked
against Soup library.

%package gir
Summary: GObject introspection data for the Soup library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides GObject introspection data for the Soup library

%package gir-devel
Summary: GObject introspection devel data for the Soup library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
libsoup is an HTTP client/server library for GNOME. It uses GObjects
and the glib main loop, to integrate well with GNOME applications.

This package provides GObject introspection devel data for the Soup library

%prep
%setup -n %_name-%version

%build
%ifarch %e2k
%add_optflags -Wno-error=pointer-arith
%endif
%meson \
    %{?_enable_debug:--buildtype=debug} \
    %{?_enable_static:--default-library=both} \
    %{?_enable_gnome:-Dgnome=true} \
    %{?_enable_gtk_doc:-Dgtk_doc=true} \
    %{?_enable_snapshot:-Dgtk_doc=true} \
    %{?_disable_introspection:-Dintrospection=disabled} \
    %{?_disable_gssapi:-Dgssapi=disabled} \
    %{?_enable_sysprof:-Dsysprof=enabled}
%meson_build

%install
%meson_install
%find_lang --output=%_name.lang %_name-%api_ver

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %_name.lang
%_libdir/%_name-%api_ver.so.*
%doc README NEWS AUTHORS

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%{?_enable_vala:%_vapidir/%_name-%api_ver.vapi}
%{?_enable_vala:%_vapidir/%_name-%api_ver.deps}

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files gir
%_typelibdir/Soup-%api_ver.typelib

%files gir-devel
%_girdir/Soup-%api_ver.gir
%endif

%changelog
