%def_disable snapshot
%define api_ver 2.0
%def_enable check

Name: libusbmuxd
Version: 2.0.2
Release: alt1

Summary: Interface library for usbmuxd
Group: System/Libraries
License: LGPL-2.1
Url: http://www.libimobiledevice.org/

%if_disabled snapshot
Source: https://github.com/libimobiledevice/libusbmuxd/archive/%version/%name-%version.tar.gz
%else
# VCS: https://github.com/libimobiledevice/libusbmuxd.git
Source: %name-%version.tar
%endif

BuildRequires: gcc-c++ libusb-devel >= 1.0.3 libplistmm-devel >= 2.2.0

%description
usbmuxd (USB Multiplex Daemon) is a daemon used for communicating with
Apple's iPod Touch and iPhone devices. It allows multiple services on
the device to be accessed simultaneously.

This package contains the usbmuxd communication interface library -
'libusbmuxd'.

%package devel
Summary: Development package for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides headers and libraries needed for development
%name clients.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_bindir/iproxy
%_bindir/inetcat
%_libdir/libusbmuxd-%api_ver.so.*
%_man1dir/iproxy.1*
%_man1dir/inetcat.1*

%files devel
%_includedir/*.h
%_libdir/libusbmuxd-%api_ver.so
%_pkgconfigdir/libusbmuxd-%api_ver.pc

%changelog
