%def_disable snapshot

%define ver_major 2.5
%define sover 9
%def_disable docs

%ifnarch %valgrind_arches
%def_disable tests
%def_disable check
%else
%def_disable tests
%def_enable check
%endif

Name: libwacom
Version: %ver_major.0
Release: alt2

Summary: A Wacom tablets library
Group: System/Libraries
License: MIT
Url: https://github.com/linuxwacom/libwacom

%if_disabled snapshot
Source: %url/releases/download/%name-%version/%name-%version.tar.xz
%else
Vcs: https://github.com/linuxwacom/libwacom.git
Source: %name-%version.tar
%endif

Requires: %name-data = %version-%release
Requires: python3-module-pyudev python3-module-libevdev

BuildRequires(pre): rpm-macros-meson rpm-macros-valgrind rpm-build-python3
BuildRequires: /proc meson glib2-devel libgudev-devel libxml2-devel
%{?_enable_docs:BuildRequires: doxygen graphviz}
%{?_enable_tests:
BuildRequires: python3-module-pytest
BuildRequires: udev libudev-devel python3-module-pyudev
BuildRequires: libevdev-devel python3-module-libevdev
BuildRequires: valgrind}

%description
%name is a library to identify Wacom tablets and their model-specific
features. It provides easy access to information such as "is this a
built-in on-screen tablet", "what is the size of this model", etc.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package data
Summary: Tablets data for %name
Group: System/Libraries
BuildArch: noarch

%description data
%name is a library to identify wacom tablets and their model-specific
features.

This package contains tablets/stylus data for %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-doc
The %name-devel-doc package contains documentation for
developing applications that use %name.

%prep
%setup
%{?_enable_tests:sed -i 's/pytest-3/py.test-3/' meson.build}

%build
%meson \
    -Dudev-dir='/lib/udev' \
    %{?_disable_docs:-Ddocumentation=disabled} \
    %{?_disable_tests:-Dtests=disabled} \
    %{?optflags_lto:-Db_lto=true}
%nil
%meson_build

%install
%meson_install
# since 1.9 libwacom can read tablet and stylus files from /etc/libwacom
mkdir -p %buildroot%_sysconfdir/%name

%check
%__meson_test

%files
%dir %_sysconfdir/%name
%_bindir/%name-list-local-devices
%_bindir/%name-list-devices
%_bindir/%name-update-db
%_bindir/%name-show-stylus
%_libdir/*.so.%{sover}*
%_udevrulesdir/65-libwacom.rules
%_man1dir/libwacom-list-local-devices.1*
%_man1dir/libwacom-list-devices.1*
%doc NEWS README* COPYING

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files data
%dir %_datadir/%name
%_datadir/%name/*.tablet
%_datadir/%name/*.stylus
%_datadir/%name/layouts/
%_udevhwdbdir/65-%name.hwdb

#%files devel-doc
#%_datadir/gtk-doc/html/*

%changelog
