%define rname webrtc-audio-processing

Name: lib%rname
Version: 1.3
Release: alt2

Summary: WebRTC Audio Processing library
License: BSD
Group: System/Libraries

Url: https://freedesktop.org/software/pulseaudio/%rname/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %url/%rname-%version.tar.gz
Patch: webrtc-fix-typedefs-on-other-arches.patch
Patch2000: webrtc-e2k.patch

BuildRequires: gcc-c++ meson libabseil-cpp-devel

%description
WebRTC is an open source project that enables web browsers with
Real-Time Communications (RTC) capabilities via simple Javascript APIs.
The WebRTC components have been optimized to best serve this purpose.
WebRTC implements the W3C's proposal for video conferencing on the web.

%package devel
Summary: WebRTC Audio Processing library and header files
Group: Development/C

%description devel
libwebrtc-devel contains the libraries and header files needed to
develop programs which make use of %rname

%prep
%setup -n %rname-%version
%patch -p1
%ifarch %e2k
%patch2000 -p1
%endif

%build
%add_optflags -Wno-return-type
%ifarch %ix86
%add_optflags -march=native
%endif
%ifarch %e2k
cat > c++ << "EOF"
#!/bin/bash
i=0; for arg; do
  [[ "$arg" =~ -labsl_.* && "${arr[@]}" =~ "$arg" ]] || arr[i++]="$arg"
done
exec /usr/bin/c++ "${arr[@]}"
EOF
chmod +x c++
export CXX=$(pwd)/c++
%endif
%meson
%meson_build

%install
%meson_install

%files
%doc NEWS README.md
%_libdir/*.so.*

%files devel
%_includedir/webrtc-audio-processing-1
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
