%define lIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define lIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define lIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define lIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

# define names and paths of QT/KDE packages
%define glibc_core_ver %{get_version glibc-core}

%define _optlevel s
%define socks 0
%define cvs 0
%define no_some_docs 1

#Licq is not adopted for openssl 1.1
#
#SSL used only for direct connections that are not available
#since the IP addresses are hidden. So, disabled it.
%def_disable ssl

#UI plugins
%define with_qt5 1
%define with_kde4 0
# removed some time ago (near version 1.4)
%define with_gtk 0
# removed in 1.8.0
%define with_console 0

#protocol plugins
%define with_msn 1
%define with_jabber 1
%define with_icq 1

#other plugins
%define with_email 1
%define with_auto_reply 1
%define with_rms 1
%define with_osd 1
%define with_aosd 1
%define with_gpg 1
%define with_dbus 0

# name-version-release
%define rname licq
%define ver 1.8.2
%define rlz alt4

%define common_summary Multi-protocol IM-client (icq,jabber,msn) written on C++

%if_with ssl
%define common_description Licq was written as ICQ clone but it is multi-protocol IM now.\
Licq supports different interfaces, protocols and functions via plugins.\
\
This package contains the base files for Licq (the Licq daemon) and the QT\
plugin, which is written using the Qt widget set. Currently this UI plugin\
is only available (since v1.8).\
\
This starts the QT plugin by default, so to run other plugins, you will have\
to issue the command "licq -p <plugin>" once. To get back the Qt plugin, you\
will have to run once "licq -p qt-gui". Alternatively you may be able to do\
it in a plugin dialog box if your plugin supports this feature.\
\
This version of Licq has SSL support for those plugins that support it.
%else
%define common_description Licq was written as ICQ clone but it is multi-protocol IM now.\
Licq supports different interfaces, protocols and functions via plugins.\
\
This package contains the base files for Licq (the Licq daemon) and the QT\
plugin, which is written using the Qt widget set. Currently this UI plugin\
is only available (since v1.8).\
\
This starts the QT plugin by default, so to run other plugins, you will have\
to issue the command "licq -p <plugin>" once. To get back the Qt plugin, you\
will have to run once "licq -p qt-gui". Alternatively you may be able to do\
it in a plugin dialog box if your plugin supports this feature.
%endif

Name: %rname
Version: %ver
Release: %rlz

%if %with_kde4
BuildRequires(pre): rpm-build-kf5
%endif
BuildRequires(pre): graphviz

BuildRequires: cmake
BuildRequires: freetype2-devel gcc-c++ chrpath
BuildRequires: libart_lgpl-devel libexpat-devel libjpeg-devel
BuildRequires: liblcms-devel libmng-devel kde-common-devel
BuildRequires: libncurses-devel libstdc++-devel libtinfo-devel
BuildRequires: rpm-utils boost-devel doxygen libgloox-devel
BuildRequires: libpixman-devel libharfbuzz-devel
%if_with ssl
BuildRequires: libssl-devel
%endif
%if %with_console
BuildRequires: libcdk-devel
%endif
%if %with_qt5
BuildRequires: qt5-base-devel qt5-tools-devel
%endif
%if %with_kde4
BuildRequires: rpm-build-kf5
%endif
%if %socks
BuildRequires: libdante-devel
%endif
%if %with_gtk
BuildRequires: libgtk+2-devel
%endif
%if %with_osd
BuildRequires: libxosd-devel cvs
%endif
%if %with_aosd
BuildRequires: libaosd-devel glib2-devel
%endif
%if %with_gpg
BuildRequires: libgpgme-devel libgpg-error-devel
%endif

########################
Source: %name.tar
%if %with_auto_reply
#Source1: ftp://ftp.licq.org/pub/licq/plugins/%name-auto-reply-%%cvsdate.tar
%endif
%if %with_gtk
Source5: ftp://ftp.licq.org/pub/licq/plugins/icqnd-0.1.9.6.tar
%endif

########################

Source9: licq-tracepath.utility
Source10: licq-viewurl.sh
Source21: %name.16.xpm.bz2
Source22: %name.32.xpm.bz2
Source23: %name.48.xpm.bz2

Patch2: licq-1.5.0-alt-xvt.patch
Patch3: licq-1.7.0-alt-qt4-def-encoding.patch
#
Patch17: licq_osd_plugin-1.3.2.1-defaults.patch
#
Patch22: licq-1.3.6-alt-qt4-yes-stl.patch

Patch50: %name-%version-alt-gcc6.patch

Patch200: licq-1.2.7-remove-pidfile.patch

Patch300: 0001-Rename-qt4-gui-to-qt-gui-in-preparation-of-qt5-port.patch
Patch301: 0002-Rename-plugin-to-qt-gui.patch
Patch302: 0003-qt-gui-Code-cleanup-to-help-Qt5-migration.patch
Patch303: 0004-qt-gui-make-it-possible-to-build-the-plugin-with-Qt5.patch
Patch304: 0007-api-Add-util-to-run-external-commands.patch
Patch305: 0008-auto-reply-Use-Licq-Exec-to-run-commands.patch
Patch306: 0009-icq-Move-auto-response-generation-to-daemon.patch
Patch307: 0010-Remove-support-for-utilities.patch
Patch308: 0012-qt-gui-Remove-mass-message-function.patch
Patch309: 0013-icq-Drop-support-for-sending-SMS.patch
Patch310: 0014-qt-gui-Move-emoticon-selection-to-widgets-dir.patch
Patch311: 0015-qt-gui-fix-translation-building-closes-45.patch

#Errata
#Patch500:

#package licq
Group: Networking/Instant messaging
Summary: %common_summary
License: GPL
Url: http://www.licq.org/
Requires: %name-jabber = %version-%release
%if %with_osd
Requires: %name-osd = %version-%release
%endif
%if %with_kde4
Requires: %name-kde4 = %version-%release
%else
Requires: %name-ui
%endif


%package maxi
Group: Networking/Instant messaging
Summary: %common_summary
BuildArch: noarch
%if %with_msn
Requires: %name-msn = %version-%release
%endif
%if %with_jabber
Requires: %name-jabber = %version-%release
%endif
%if %with_email
Requires: %name-email = %version-%release
%endif
%if %with_auto_reply
Requires: %name-autoreply = %version-%release
%endif
%if %with_rms
Requires: %name-rms = %version-%release
%endif
%if %with_osd
Requires: %name-osd = %version-%release
%endif
%if %with_aosd
Requires: %name-aosd = %version-%release
%endif
%if %with_qt5
Requires: %name-qt5 = %version-%release
%else
Requires: %name-ui
%endif
%if %with_kde4
Requires: %name-kde4 = %version-%release
%else
Requires: %name-ui
%endif
%if %with_gtk
Requires: %name-gtk = %version-%release
%else
Requires: %name-ui
%endif
%if %with_console
Requires: %name-console = %version-%release
%else
Requires: %name-ui
%endif

%package mini
Group: Networking/Instant messaging
Summary: %common_summary
BuildArch: noarch
%if %with_qt5
Requires: %name-qt5 = %version-%release
%else
Requires: %name-ui
%endif

%package common
Summary: Common binaries and data files  for Licq
Group: Networking/Instant messaging
%if_with ssl
Obsoletes: %name-ssl < %version-release
%endif
Obsoletes: %name-data < %version-release
Obsoletes: %name-update-hosts < %version-release
Provides: %name-base = %version-release
Obsoletes: %name-base < %version-release
Requires: sound_handler

%package kde4
Group: Networking/Instant messaging
Summary: The default Licq's plugin for KDE4
Provides: %name-plugin %name-ui
Provides: licq-kde = %version-%release
Obsoletes: licq-kde < %version-%release
Requires: %name-common = %version-%release
Requires: %name-qt5

%package qt5
Summary: Qt4 based GUI plugin  for Licq
Group: Networking/Instant messaging
Provides: %name-plugin %name-ui
Provides: licq-qt = %EVR
Obsoletes: licq-qt < %EVR
Provides: licq-qt4 = %EVR
Obsoletes: licq-qt4 < %EVR
Requires: %name-common = %version-%release
%package gtk
Summary: GTK+ based GUI plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin %name-ui
Requires: %name-common = %version-%release

%package console
Summary: Console based plugin for Licq that uses ncurses
Group: Networking/Instant messaging
Provides: %name-plugin %name-ui
Requires: %name-common = %version-%release

%package email
Summary: Email forwarder plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin, %name-forwarder = %version-%release
Obsoletes: %name-forwarder < %version-%release
Requires: %name-common = %version-%release

%package autoreply
Summary: Autoreply plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package rms
Summary: Remote management service plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package osd
Summary: OSD (On Screen Dysplay) plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package aosd
Summary: OSD (On Screen Dysplay) plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package icq
Summary: ICQ protocol plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package msn
Summary: MSN protocol plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package jabber
Summary: XMPP(Jabber) protocol plugin for Licq
Group: Networking/Instant messaging
Provides: %name-plugin
Requires: %name-common = %version-%release

%package devel
Summary: Development files for Licq
Group: Development/C
Requires: %name-common = %version-%release
BuildArch: noarch

%description
%common_description

%description maxi
%common_description

%description mini
%common_description

%description kde4
This is the KDE4 based GUI plugin for Licq.
Install this if you want a KDE4-based GUI for Licq.

%description common
Common binaries and data files  for Licq

%description devel
This is the header files that you will need in order to compile Licq plugins.

%description rms
RMS stands for the Remote Management Service. It is a plugin for Licq which
enables you to "telnet" to your Licq box to perform various tasks. Security is
implemented through basic username and password authentication.

%description qt5
This is the Qt based GUI for Licq.
Install this and if you want a Qt-based GUI for Licq.

%description gtk
This is the GTK+ based GUI plugin for Licq.
Install this if you want a GTK+ based GUI for Licq.

%description console
This is a console based plugin for Licq that uses ncurses that came in the
standard Licq source package. It is extremely usable and functional, but it
does not currently have support for gpm.

Install this if you want to run Licq on the console.

%description email
This plugin for Licq lets you forward messages to your email account. This is a
plugin that came with the standard Licq source package. It can be run
concurrently with a UI plugin.

Install this if you want to add this function to Licq.

%description autoreply
This plugin for Licq enables Licq to auto reply to messages. This is a plugin
standard Licq source package. It can be run concurrently with a UI plugin.

Install this if you want to add this function to Licq.

%description osd
This is a small plugin, which uses libxosd2 to
display new arriving messages as OSD (On Screen Display)
text on your desktop.

Install this if you want to add this function to Licq.

%description aosd
This is a small plugin, which uses libaosd to
display new arriving messages as OSD (On Screen Display)
text on your desktop.

Install this if you want to add this function to Licq.

%description icq
ICQ Protocol Plugin.

Install this if you want to add this function to Licq.

%description msn
MSN Protocol Plugin.

Install this if you want to add this function to Licq.

%description jabber
Jabber(XMPP) Protocol Plugin.

Install this if you want to add this function to Licq.

### PREP ##########################################
%prep
%ifdef autoreconf
%undefine autoreconf
%define autoreconf aclocal --force; autoconf; automake
%endif

%setup -q -n %name

#Errata
#patch500 -p2

%if %with_gtk
    tar xf %SOURCE5
    mv icqnd-* icqnd
    ln -s ../../icqnd licq/plugins/icqnd
%endif

install -m 644 %SOURCE9 licq/share/utilities/tracepath.utility

pushd licq
%patch2 -p1
popd

%if %with_osd
pushd osd*
%patch17 -p1
popd
%endif

# with_qt || with_kde
pushd qt4-gui*
%patch3 -p0
%patch22 -p1
popd

%patch300 -p1
%patch301 -p1
%patch302 -p1
%patch303 -p1
%patch304 -p1
%patch305 -p1
%patch306 -p1
%patch307 -p1
%patch308 -p1
%patch309 -p1
%patch310 -p1
%patch311 -p1

%patch50 -p1

%if %with_aosd
%else
    rm -rf licq/plugins/aosd
%endif
%if %with_console
%else
    rm -rf licq/plugins/console
%endif
%if %with_dbus
%else
    rm -rf licq/plugins/dbus
%endif

sed -i 's|kde4|kf5|' qt-gui/share/misc/CMakeLists.txt
rm -rf qt4-gui
rm -rf licq/plugins/qt4-gui
rm -rf licq/plugins/qt-gui
ln -sf ../../qt-gui licq/plugins/qt-gui

%if %with_kde4
cp -ar qt-gui kde-gui
ln -sf ../../kde-gui licq/plugins/kde-gui
sed -i "s|\s*Name\s*=.*|Name=Licq [KDE]|" kde-gui/share/misc/licq.desktop
sed -i "s|\s*Exec\s*=.*|Exec=licq -p kde-gui|" kde-gui/share/misc/licq.desktop
sed -i 's|add_subdirectory(doc)||' kde-gui/CMakeLists.txt
%endif

%if %with_qt5
sed -i "s|\s*Name\s*=.*|Name=Licq [Qt]|" qt-gui/share/misc/licq.desktop
sed -i "s|\s*Exec\s*=.*|Exec=licq -p qt-gui|" qt-gui/share/misc/licq.desktop
find ./qt-gui -type f -name CMakeLists.txt | \
while read f; do
    sed -i 's|WITH_KDE|QT_WITH_KDE|' $f
done
%endif

### BUILD ##########################################
%build
#add_optflags -D_FILE_OFFSET_BITS=64
#export CFLAGS="%optflags" CXXFLAGS="%optflags" CPPFLAGS="%optflags"

pushd licq
%K5cmake \
    -DINCLUDE_INSTALL_DIR=%_includedir \
    -DINSTALL_LIBDIR=%_libdir \
    -DQT_WITH_KDE:BOOL=OFF \
    -DWITH_KDE:BOOL=ON \
    -DWITH_QT5:BOOL=ON \
    -DUSE_OPENSSL:BOOL=%{?_enable_ssl:ON}%{!?_enable_ssl:OFF} \
    -DBUILD_TESTS:BOOL=OFF \
    -DBUILD_PLUGINS:BOOL=ON \
    #
%K5make
popd

### INSTALL ##########################################
%install
pushd licq
%K5install
popd

rm -rf %buildroot/%_datadir/licq/translations

#mkdir -p %buildroot/%_bindir
%if_with ssl
ln -fs licq %buildroot/%_bindir/licq-ssl
%endif
install -m755 %SOURCE10 %buildroot/%_bindir/licq-viewurl.sh

mkdir -p %buildroot/%_miconsdir
mkdir -p %buildroot/%_niconsdir
mkdir -p %buildroot/%_liconsdir
bzip2 -dc %SOURCE21 > %buildroot/%_miconsdir/licq.xpm
bzip2 -dc %SOURCE22 > %buildroot/%_niconsdir/licq.xpm
bzip2 -dc %SOURCE23 > %buildroot/%_liconsdir/licq.xpm

# menu stuff GTK
%if %with_gtk
mkdir -p %buildroot/%_menudir
cat > %buildroot/%_menudir/%name-gtk <<EOF
    ?package(licq-gtk):\
    command="licq -p gtk-gui"\
    icon="licq.xpm"\
    title="Licq [GTK]"\
    longtitle="ICQ client"\
    needs="x11"\
    section="Networking/Instant messaging"
EOF
%endif

# menu stuff console
%if %with_console
mkdir -p %buildroot/%_menudir
cat > %buildroot/%_menudir/%name-console <<EOF
    ?package(licq-console):\
    command="licq -p console"\
    icon="licq.xpm"\
    title="Licq [console]"\
    longtitle="Text based ICQ client"\
    needs="text"\
    section="Networking/Instant messaging"
EOF
%endif


%if %with_gtk
pushd plugins/icqnd
%make install DESTDIR=%buildroot libdir=%_libdir/%name
ln -s licq_icqnd.so %buildroot/%_libdir/licq/licq_gtk-gui.so
popd
%endif

# remove rpath from plugins
#find %buildroot -type f -name \*.so | while read f; do chrpath -d $f; done

%find_lang %name
%find_lang licq_osd_plugin


### FILES ##########################################
#
%files
%files maxi
%files mini

%if %with_kde4
## kde4 plugin
%files kde4
%_libdir/licq/licq*kde-gui*
%_desktopdir/kf5/licq.desktop
%endif

%if %with_qt5
## licq qt plugin
%files qt5
%_libdir/licq/licq*qt-gui*
%_datadir/licq/qt-gui/
%_desktopdir/licq.desktop
%endif

## licq base
%files common -f %name.lang
%_bindir/licq
%if_with ssl
%_bindir/licq-ssl
%endif
%dir %_libdir/licq/
%dir %_datadir/licq/
#%_datadir/licq/utilities/
%_datadir/licq/sounds/
%_miconsdir/licq.xpm
%_niconsdir/licq.xpm
%_liconsdir/licq.xpm
%attr(0755,root,root) %_bindir/licq-viewurl.sh
%doc licq/doc/ licq/upgrade/ licq/README*
%if !%no_some_docs
%doc licq/ChangeLog
%endif
%if %with_gpg
%doc licq/licq_gpg.conf
%endif

%if %with_gtk
## gtk plugin
%files gtk
%_menudir/licq-gtk
%_libdir/licq/licq*icqnd*
%_libdir/licq/licq*gtk-gui*
%_datadir/licq/icqnd
%endif

%if %with_osd
## osd plugin
%files osd -f licq_osd_plugin.lang
%_libdir/licq/licq_osd.*
%doc osd*/%{name}_osd.conf
%doc osd*/{AUTHORS,TODO,README}
%endif

%if %with_osd
## aosd plugin
%files aosd
%_libdir/licq/licq_aosd.*
#%doc aosd*/%{name}_osd.conf
%doc aosd*/README
%endif

%if %with_icq
## icq plugin
%files icq
%_libdir/licq/protocol_icq.*
%endif

%if %with_msn
## msn plugin
%files msn
%_libdir/licq/protocol_msn.*
%doc msn*/owner.MSN_
%doc msn*/README
%endif

%if %with_jabber
## jabber plugin
%files jabber
%_libdir/licq/protocol_jabber.*
%doc jabber*/README
%endif

## devel
%files devel
%_includedir/licq
%_datadir/licq/cmake

%if %with_console
## console plugin
%files console
%_menudir/licq-console
%_libdir/licq/licq_console.*
%doc console*/README
%doc console*/%{name}_console.conf
%endif


%if %with_email
## email plugin
%files email
%_libdir/licq/licq_forwarder.*
%doc forwarder*/README
%doc forwarder*/%{name}_forwarder.conf
%endif

%if %with_auto_reply
## auto reply plugin
%files autoreply
%_libdir/licq/licq_autoreply.*
%doc auto-reply*/README
%doc auto-reply*/%{name}_autoreply.conf
%endif

%if %with_rms
## remote management svcx
%files rms
%_libdir/licq/licq_rms.*
%doc rms*/README
%doc rms*/%{name}_rms.conf
%endif

########################################################
%changelog
