# -*- mode: rpm-spec; coding: utf-8 -*-
%define _perl_lib_path %_datadir/%name/lib

Name: logwatch
Version: 7.4.0
Release: alt1

Summary: Analyzes and Reports on system logs
License: MIT
Group: Monitoring
Url: http://www.logwatch.org
BuildArch: noarch
Source: %name-%version.tar
Source1: %name.sysconfig
Source2: %name.cron
Source3: ignore.conf
Source4: override.conf

Packager: Evgenii Terechkov <evg@altlinux.org>

BuildPreReq: perl-base
PreReq: mailx

%description
Logwatch is a customizable, pluggable log-monitoring system.  It will go
through your logs for a given period of time and make a report in the areas
that you wish with the detail that you wish.  Easy to use - works right out
of the package on many systems.

%prep
%setup

%build
%install
install -m 0755 -d %buildroot%_var/cache/%name
install -m 0755 -d %buildroot%_sysconfdir/%name/scripts
install -m 0755 -d %buildroot%_sysconfdir/%name/conf
install -m 0755 -d %buildroot%_sysconfdir/%name/conf/logfiles
install -m 0755 -d %buildroot%_sysconfdir/%name/conf/services
install -m 0755 -d %buildroot%_datadir/%name/default.conf/logfiles
install -m 0755 -d %buildroot%_datadir/%name/default.conf/services
install -m 0755 -d %buildroot%_datadir/%name/default.conf/html
install -m 0755 -d %buildroot%_datadir/%name/dist.conf/logfiles
install -m 0755 -d %buildroot%_datadir/%name/dist.conf/services
install -m 0755 -d %buildroot%_datadir/%name/scripts/services
install -m 0755 -d %buildroot%_datadir/%name/scripts/shared
install -m 0755 -d %buildroot%_datadir/%name/lib

install -m 0755 scripts/%name.pl %buildroot%_datadir/%name/scripts/%name.pl
for i in scripts/logfiles/* ; do
   if [ $(ls $i | wc -l) -ne 0 ] ; then
      install -m 0755 -d %buildroot%_datadir/%name/$i
      install -m 0755 $i/* %buildroot%_datadir/%name/$i
   fi
done
install -m 0755 scripts/services/* %buildroot%_datadir/%name/scripts/services
install -m 0755 scripts/shared/* %buildroot%_datadir/%name/scripts/shared
install -m 0755 lib/* %buildroot%_datadir/%name/lib

install -m 0644 conf/*.conf %buildroot%_datadir/%name/default.conf
install -m 0644 conf/logfiles/* %buildroot%_datadir/%name/default.conf/logfiles
install -m 0644 conf/services/* %buildroot%_datadir/%name/default.conf/services
install -m 0644 conf/html/* %buildroot%_datadir/%name/default.conf/html

install -m 0755 -d %buildroot%_man8dir %buildroot%_man5dir
install -m 0644 ignore.conf.5 %buildroot%_man5dir
install -m 0644 %name.conf.5 %buildroot%_man5dir
install -m 0644 override.conf.5 %buildroot%_man5dir
install -m 0644 %name.8 %buildroot%_man8dir

install -m 0755 -d %buildroot%_sysconfdir/cron.daily %buildroot%_sysconfdir/sysconfig
install -m 644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/%name
install -m 0755 %SOURCE2 %buildroot%_sysconfdir/cron.daily/0%name

install -m 0755 -d %buildroot%_sbindir
ln -s %_datadir/%name/scripts/%name.pl %buildroot%_sbindir/%name

echo "# Local configuration options go here (defaults are in %_datadir/%name/default.conf/%name.conf)" > %buildroot%_sysconfdir/%name/conf/%name.conf
install -m 644 %SOURCE3 %buildroot%_sysconfdir/%name/conf/ignore.conf
install -m 644 %SOURCE4 %buildroot%_sysconfdir/%name/conf/override.conf

%files
%_sysconfdir/cron.daily/0%name

%dir %_var/cache/%name
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/scripts
%dir %_sysconfdir/%name/conf
%dir %_sysconfdir/%name/conf/logfiles
%dir %_sysconfdir/%name/conf/services
%dir %_datadir/%name
%dir %_datadir/%name/default.conf
%dir %_datadir/%name/default.conf/services
%dir %_datadir/%name/default.conf/logfiles
%dir %_datadir/%name/default.conf/html
%dir %_datadir/%name/dist.conf
%dir %_datadir/%name/dist.conf/services
%dir %_datadir/%name/dist.conf/logfiles
%dir %_datadir/%name/scripts
%dir %_datadir/%name/scripts/logfiles
%dir %_datadir/%name/scripts/services
%dir %_datadir/%name/scripts/shared
%dir %_datadir/%name/scripts/logfiles/*
%dir %_datadir/%name/lib
%_datadir/%name/scripts/%name.pl
%_sbindir/%name
%_datadir/%name/scripts/shared/*
%_datadir/%name/scripts/services/*
%_datadir/%name/scripts/logfiles/*/*
%_datadir/%name/lib/Logwatch.pm
%_datadir/%name/default.conf/*.conf
%_datadir/%name/default.conf/services/*.conf
%_datadir/%name/default.conf/logfiles/*.conf
%_datadir/%name/default.conf/html/*.html
%doc %_man5dir/*.5*
%doc %_man8dir/%name.8*
%config(noreplace) %_sysconfdir/%name/conf/*.conf
%config(noreplace) %_sysconfdir/sysconfig/%name

%doc README HOWTO* LICENSE

%changelog
