Name: mlocate
Version: 0.26
Release: alt2

Summary: An utility for finding files by name

License: GPLv2
Url: https://fedorahosted.org/mlocate/
Group: System/Base

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://fedorahosted.org/releases/m/l/mlocate/mlocate-%version.tar
Source1: updatedb.conf
Source2: mlocate.cron

# TODO
#BuildPreReq: gnulib

# for groupadd
BuildPreReq: rpm-build-intro

Conflicts: slocate
#Obsoletes: slocate <= 2.7-30

%description
mlocate is a locate/updatedb implementation.  It keeps a database of
all existing files and allows you to lookup files by name.

The 'm' stands for "merging": updatedb reuses the existing database to avoid
rereading most of the file system, which makes updatedb faster and does not
trash the system caches as much as traditional locate implementations.

%prep
%setup
# put to /var/lib instead /var
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382 also
%__subst 's|$(localstatedir)|$(sharedstatedir)|g' Makefile.*
#rm -rf gnulib
#cp -as /usr/share/gnulib .

%build
%configure
%make_build groupname=slocate

%install
%makeinstall_std groupname=slocate

mkdir -p %buildroot{%_sysconfdir,%_sysconfdir/cron.daily}
install -p -m 644 %SOURCE1 %buildroot%_sysconfdir/updatedb.conf
install -p -m 755 %SOURCE2 %buildroot%_sysconfdir/cron.daily/mlocate.cron

# for %%ghost
touch %buildroot%_sharedstatedir/mlocate/mlocate.db

%find_lang mlocate

%pre
%groupadd slocate

%post
if /bin/grep -q '^[^#]*DAILY_UPDATE' %_sysconfdir/updatedb.conf; then
    /bin/sed -i.rpmsave -e '/DAILY_UPDATE/s/^/#/' %_sysconfdir/updatedb.conf
fi

if [ ! -f %_sharedstatedir/mlocate/%name.db ]; then
    echo 'Run "%_bindir/updatedb" if you want to make %name database immediately.'
fi

%files -f mlocate.lang
%doc AUTHORS COPYING NEWS README
%_sysconfdir/cron.daily/mlocate.cron
%config(noreplace) %_sysconfdir/updatedb.conf
%attr(2711,root,slocate) %_bindir/locate
%_bindir/updatedb
%_mandir/man*/*
%dir %attr(0750,root,slocate) %_sharedstatedir/mlocate
%ghost %_sharedstatedir/mlocate/mlocate.db

%changelog
