Name: neovim
Version: 0.9.1
Release: alt1

Summary: heavily refactored vim fork

License: Apache-2.0 and Vim
Group: Editors
Url: https://neovim.io/

# git://git.altlinux.org/gears/n/neovim.git
Source: %name-%version-%release.tar
Source1: %name.watch
Source2: sysinit.vim

BuildRequires(pre): rpm-macros-cmake cmake

BuildRequires: /proc
BuildRequires: gcc-c++
BuildRequires: gperf
BuildRequires: libjemalloc-devel
BuildRequires: libmsgpack-c-devel
BuildRequires: libtermkey-devel
BuildRequires: libuv-devel
BuildRequires: libvterm-devel
BuildRequires: luajit libluajit-devel
BuildRequires: lua5.1-module-lpeg lua5.1-mpack
BuildRequires: libluv-devel
BuildRequires: unibilium-devel
BuildRequires: libtree-sitter-devel

ExcludeArch: armh

Provides: nvim = %EVR
Requires: %name-runtime = %EVR

%package runtime
Summary: heavily refactored vim fork - runtime files
Group: Editors

%define common_descr \
Neovim is a refactor, and sometimes redactor, in the tradition of Vim (which\
itself derives from Stevie). It is not a rewrite but a continuation and\
extension of Vim. Many clones and derivatives exist; some are very clever, but\
none are Vim. Neovim strives to be a superset of Vim except for some\
intentionally-removed misfeatures. It is built for users who want the good parts\
of Vim, and more.

%description
%common_descr

%description runtime
%common_descr

This package contains runtime files.

%prep
%setup

%build
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DNVIM_VERSION_RELEASE=%release \
	#
%cmake_build

%install
%cmake_install
%find_lang nvim

install -pm0644 runtime/nvim.desktop -Dt %buildroot%_desktopdir
install -pm0644 runtime/nvim.png -Dt %buildroot%_pixmapsdir

install -pm0644 %SOURCE2 %buildroot%_datadir/nvim

%files -f nvim.lang
%doc LICENSE.txt
%_bindir/nvim
%_man1dir/nvim*
%exclude %_datadir/locale/cs.cp1250
%exclude %_datadir/locale/ja.euc-jp
%exclude %_datadir/locale/sk.cp1250

%_desktopdir/nvim.desktop
%_pixmapsdir/nvim.png
%_iconsdir/hicolor/*/apps/nvim.png

%files runtime
%dir %_datadir/nvim
%dir %_datadir/nvim/runtime
%_datadir/nvim/runtime/*
%_datadir/nvim/sysinit.vim

%changelog
