Name: nfs
Version: 2.5.4
Release: alt1
Epoch: 1

Summary: The Linux NFS clients, utilities and server
License: GPLv2
Group: Networking/Other
Url: http://nfs.sourceforge.net/

Source0: %name-%version-%release.tar

BuildRequires: libblkid-devel libevent-devel libuuid-devel
BuildRequires: libdevmapper-devel libkrb5-devel libsqlite3-devel
BuildRequires: libcap-devel libtirpc-devel libkeyutils-devel libmount-devel
BuildRequires: rpcgen rpcsvc-proto-devel
BuildRequires: rpm-build-python3

%package -n libnfsidmap
Summary: Name to user id mapping library
Group: System/Libraries

%package -n libnfsidmap-devel
Summary: Name to user id mapping library and headers
Group: Development/C
Requires: libnfsidmap = %EVR

%package clients
Summary: The Linux NFS client
Group: Networking/Other

PreReq: shadow-utils
PreReq: %name-utils = %epoch:%version-%release
Requires(post): %post_service
Requires(preun): %preun_service
Requires: keyutils >= 1.4-alt2
Conflicts: libnfsidmap < 0.23

%package server
Summary: The Linux NFS server
Group: Networking/Other

PreReq: %name-clients = %epoch:%version-%release
Requires(post): %post_service
Requires(preun): %preun_service

%package utils
Summary: The Linux NFS services utilities
Group: Networking/Other

PreReq: control
Requires: rpcbind >= 0.2.0-alt1
Conflicts: mount < 2.12r-alt2
Conflicts: nfs-clients = 1:1.0.10-alt2

%package stats
Summary: The Linux NFS stats utilities
Group: Networking/Other
Conflicts: nfs-utils < 1:1.2.4-alt0.4

%description
This package provides the Linux NFS utilities and server.
This package replaces the old knfsd package.

%description -n libnfsidmap
libnfsidmap is a library holding mulitiple methods of mapping names to id's
and visa versa, mainly for NFSv4.

%description -n libnfsidmap-devel
libnfsidmap is a library holding mulitiple methods of mapping names to id's
and visa versa, mainly for NFSv4.
This package holds development part of libnfsidmap library

%description clients
This package provides the Linux NFS clients.

%description server
This package provides the Linux NFS server.

%description utils
This package provides the Linux NFS utilities,
including mount.nfs helper.

%description stats
This package provides the Linux NFS stats utilities.

%prep
%setup

%build
[ -f ./autogen.sh ] && sh ./autogen.sh
%configure \
    --enable-mount \
    --enable-libmount-mount \
    --enable-gss \
    --enable-svcgss \
    --enable-tirpc \
    --enable-ipv6 \
    --with-statduser=rpcuser \
    --with-statdpath=%_localstatedir/nfs/statd \
    --with-systemd=%systemd_unitdir \
    --with-pluginpath=%_libdir/libnfsidmap \
    --disable-nfsdcld \
    --disable-static \
    #
sed -i 's/#define[[:blank:]]\+START_STATD.\+$/#undef START_STATD/' support/include/config.h
%make_build

%install
%make_install DESTDIR=%buildroot install

sed -ri 's,^#!/usr/bin/python$,&3,' %buildroot%_sbindir/{mountstats,nfsiostat}

cp -a altlinux/etc %buildroot
cp -p systemd/README README.systemd

install -pm0644 nfs.conf %buildroot%_sysconfdir/nfs.conf
install -pm0644 support/nfsidmap/idmapd.conf %buildroot%_sysconfdir/idmapd.conf

ln -s nfs-blkmap.service %buildroot%systemd_unitdir/blkmapd.service
ln -s nfs-idmapd.service %buildroot%systemd_unitdir/idmapd.service
ln -s nfs-server.service %buildroot%systemd_unitdir/nfs.service
ln -s rpc-gssd.service %buildroot%systemd_unitdir/gssd.service
ln -s rpc-statd.service %buildroot%systemd_unitdir/nfslock.service
ln -s rpc-svcgssd.service %buildroot%systemd_unitdir/svcgssd.service

mkdir -p %buildroot/sbin
mv  %buildroot%_sbindir/rpc.{statd,gssd} \
    %buildroot%_sbindir/blkmapd \
    %buildroot%_sbindir/nfsidmap \
    %buildroot%_sbindir/sm-notify %buildroot/sbin/

mkdir -p %buildroot%_localstatedir/nfs/{rpc_pipefs,v4recovery}

#-------------------------------------------------------------------------------
%pre clients
%_sbindir/groupadd -r -f rpcuser &> /dev/null
%_sbindir/useradd -r -g rpcuser -d %_localstatedir/nfs -s /dev/null -c 'RPC Service User' -n rpcuser &> /dev/null ||:
%_sbindir/groupadd -r -f nfsuser &> /dev/null
%_sbindir/useradd -r -g nfsuser -d /dev/null -s /dev/null -c 'NFS Service User' -n nfsuser &> /dev/null ||:

%pre utils
[ $1 -eq 1 ] || /usr/sbin/control-dump nfsmount

%post clients
%post_service nfslock
%post_service blkmapd
%post_service gssd

%post utils
[ $1 -eq 1 ] || /usr/sbin/control-restore nfsmount

%preun clients
%preun_service nfslock
%preun_service blkmapd
%preun_service gssd

%post server
%post_service nfs
%post_service idmapd
%post_service svcgssd

%preun server
%preun_service nfs
%preun_service idmapd
%preun_service svcgssd

%triggerpostun -- nfs-server <= 1.2.5-alt1
. /etc/init.d/functions
SourceIfNotEmpty /etc/sysconfig/nfs
is_yes "$SECURE_NFS" || exit 0
touch /var/lock/subsys/rpc.svcgssd
/sbin/chkconfig svcgssd on
/sbin/service svcgssd condrestart

#-------------------------------------------------------------------------------
%files -n libnfsidmap
%config(noreplace) %_sysconfdir/idmapd.conf
%_libdir/libnfsidmap.so.*
%dir %_libdir/libnfsidmap
%_libdir/libnfsidmap/*.so
%_man5dir/idmapd.conf.*

%files -n libnfsidmap-devel
%_libdir/libnfsidmap.so
%_includedir/nfsidmap.h
%_includedir/nfsidmap_plugin.h
%_pkgconfigdir/libnfsidmap.pc
%_man3dir/nfs4_uid_to_name.3*

%files server
%_initdir/nfs
%_initdir/idmapd
%_initdir/svcgssd

%systemd_unitdir/nfs.service
%systemd_unitdir/idmapd.service
%systemd_unitdir/svcgssd.service

%systemd_unitdir/nfs-server.service
%systemd_unitdir/nfs-mountd.service
%systemd_unitdir/nfs-idmapd.service
%systemd_unitdir/rpc-svcgssd.service
%systemd_unitdir/proc-fs-nfsd.mount

/sbin/nfsdcltrack
%_sbindir/exportfs
%_sbindir/nfsstat
%_sbindir/rpc.idmapd
%_sbindir/rpc.mountd
%_sbindir/rpc.nfsd
%_sbindir/rpc.svcgssd

%_man5dir/exports.*
%_man7dir/nfsd.*
%_man8dir/exportfs.*
%_man8dir/idmapd.*
%_man8dir/rpc.idmapd.*
%_man8dir/nfsstat.*
%_man8dir/nfsdcltrack.*
%_man8dir/mountd.*
%_man8dir/rpc.mountd.*
%_man8dir/nfsd.*
%_man8dir/rpc.nfsd.*
%_man8dir/svcgssd.*
%_man8dir/rpc.svcgssd.*

%config(noreplace) %_localstatedir/nfs/etab
%config(noreplace) %_localstatedir/nfs/rmtab
%dir %_localstatedir/nfs/v4recovery

#-------------------------------------------------------------------------------
%files clients
%doc README README.systemd
%dir %_localstatedir/nfs
%dir %_localstatedir/nfs/rpc_pipefs
%dir %attr(700,rpcuser,rpcuser) %_localstatedir/nfs/statd
%dir %attr(700,rpcuser,rpcuser) %_localstatedir/nfs/statd/sm
%dir %attr(700,rpcuser,rpcuser) %_localstatedir/nfs/statd/sm.bak
%ghost %attr(700,rpcuser,rpcuser) %_localstatedir/nfs/statd/state

%config(noreplace) %_sysconfdir/nfs.conf

%_initdir/blkmapd
%_initdir/nfslock
%_initdir/gssd

%systemd_unitdir/blkmapd.service
%systemd_unitdir/gssd.service
%systemd_unitdir/nfslock.service

%systemd_unitdir/rpc_pipefs.target
%systemd_unitdir/nfs-client.target
%systemd_unitdir/nfs-utils.service
%systemd_unitdir/auth-rpcgss-module.service
%systemd_unitdir/var-lib-nfs-rpc_pipefs.mount
%systemd_unitdir/nfs-blkmap.service
%systemd_unitdir/rpc-statd.service
%systemd_unitdir/rpc-statd-notify.service
%systemd_unitdir/rpc-gssd.service
%systemd_unitdir-generators/rpc-pipefs-generator
%systemd_unitdir-generators/nfs-server-generator

/sbin/rpc.gssd
/sbin/rpc.statd
/sbin/sm-notify
/sbin/blkmapd
/sbin/nfsidmap
%_sbindir/nfsconf

%_man5dir/nfs.conf.*
%_man7dir/nfs.systemd.*
%_man8dir/gssd.*
%_man8dir/rpc.gssd*
%_man8dir/blkmapd.*
%_man8dir/statd.*
%_man8dir/rpc.statd.*
%_man8dir/sm-notify.*
%_man8dir/rpc.sm-notify.*
%_man8dir/nfsidmap.*
%_man8dir/nfsconf.*

#-------------------------------------------------------------------------------
%files utils
%config %_sysconfdir/control.d/facilities/nfsmount
%attr(700,root,root) /sbin/mount.nfs
/sbin/mount.nfs4
/sbin/umount.*
%_bindir/showmount
%_sbindir/rpcdebug

%_man5dir/nfs.5*
%_man5dir/nfsmount.conf.*
%_man8dir/rpcdebug.*
%_man8dir/showmount.*
%_man8dir/mount.nfs.*
%_man8dir/umount.nfs.*

%files stats
%_sbindir/mountstats
%_sbindir/nfsdclnts
%_sbindir/nfsiostat
%_man8dir/mountstats.*
%_man8dir/nfsdclnts.*
%_man8dir/nfsiostat.*

%changelog
